#!/usr/bin/env python
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import CliMatcher
import CliCommand
import ConfigMount
from CliPlugin.TeCli import RouterGlobalTeModelet

CspfIntervalMsec = Tac.Type( 'Cspf::CspfIntervalMsec' )
CspfThrottleTimer = Tac.Type( 'Cspf::CspfThrottleTimer' )
config = None

#---------------------------------------------------------------------------------
# [no|default] cspf delay [initial <initial-interval> back-off <back-off-interval>]
# max <max-interval> command in config-te mode
#---------------------------------------------------------------------------------
intervalMatcher = CliMatcher.IntegerMatcher( CspfIntervalMsec.min,
      CspfIntervalMsec.max, helpdesc='Time in milliseconds' )

class CspfDelayCmd( CliCommand.CliCommandClass ):
   syntax = ( 'cspf delay [ initial INITIAL_INTERVAL back-off BACK_OFF_INTERVAL ] '
              'max MAX_INTERVAL' )
   noOrDefaultSyntax = 'cspf delay ...'
   data = {
            'cspf' : 'Configure CSPF',
            'delay' : 'Configure CSPF throttle timers',
            'initial' : 'Specify initial wait interval for CSPF',
            'INITIAL_INTERVAL' : intervalMatcher,
            'back-off' : 'Specify back-off interval for CSPF',
            'BACK_OFF_INTERVAL' : intervalMatcher,
            'max' : 'Specify maximum wait interval for CSPF',
            'MAX_INTERVAL' : intervalMatcher
          }

   @staticmethod
   def handler( mode, args ):
      initialInterval = args.get( 'INITIAL_INTERVAL', config.cspfInitialIntDefault )
      backOffInterval = args.get( 'BACK_OFF_INTERVAL', config.cspfBackOffIntDefault )
      maxInterval = args[ 'MAX_INTERVAL' ]

      if initialInterval > maxInterval:
         mode.addError(
               'CSPF initial wait interval cannot exceed max wait interval' )
         return
      if backOffInterval > maxInterval:
         mode.addError( 'CSPF back-off interval cannot exceed max wait interval' )
         return

      config.cspfTimer = CspfThrottleTimer( initialInterval, backOffInterval,
                                            maxInterval )

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      config.cspfTimer = config.cspfThrottleTimerDefault

RouterGlobalTeModelet.addCommandClass( CspfDelayCmd )

def Plugin( entityManager ):
   global config

   config = ConfigMount.mount( entityManager, "te/cspf/cliConfig",
                               "Cspf::CspfCliConfig", 'w' )
