#!/usr/bin/env python
# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tracing
import BasicCli
import CliToken.Platform
import CliPlugin.TechSupportCli
import ShowCommand
import Tac
import sys

__defaultTraceHandle__ = Tracing.Handle( 'CpuFabricCli' )

#--------------------------------------------------------------------------------
# show platform pkt
#--------------------------------------------------------------------------------
class PlatformPktCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show platform pkt'
   data = {
      'platform': CliToken.Platform.platformMatcherForShow,
      'pkt': 'CPU packet info',
   }
   privileged = True
   
   @staticmethod
   def handler( mode, args ):
      try:
         Tac.run( [ '/usr/bin/fab', 'dump' ], stdout=sys.stdout, \
                     stderr=sys.stderr, asRoot=True )
      except IOError:
         pass
      except Tac.SystemCommandError as e:
         # This exception is raised if dma driver is not loaded
         print "unsupported command: error code %s" % e.error 

BasicCli.addShowCommandClass( PlatformPktCmd )

# Register CpuFabric Cli command with 'show tech support'.
def _cpuFabricShowTechCmds():
   return [ 'show platform pkt' ]

# the older timestamp of the original show platform trident pkt
# command is retained, as this show command does not do any 
# dumping of a more recent released feature.
CliPlugin.TechSupportCli.registerShowTechSupportCmdCallback(
   '2011-05-01 14:00:00', _cpuFabricShowTechCmds )
