#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCli
import CliCommand
import CliMatcher
from CliPlugin.ControllerCli import showCvxKwMatcher
import CliPlugin.ControllerDebugCli as ControllerDebugCli
from CliPlugin.ConfigMgmtMode import managementShowKwMatcher
from CliPlugin.ControllerClient import cvxKwMatcherShowMgmt
from CliPlugin.ControllerDebugModel import PingPongStatus
import CliPlugin.ControllerdbLib as ControllerdbLib
import ShowCommand

matcherClient = CliMatcher.KeywordMatcher( 'client',
      helpdesc='Data written by debug client' )
matcherDebug = CliMatcher.KeywordMatcher( 'debug',
      helpdesc='Debug service information' )
matcherPingpong = CliMatcher.KeywordMatcher( 'pingpong',
      helpdesc='PingPong test' )
matcherServer = CliMatcher.KeywordMatcher( 'server',
      helpdesc='Data written by debug server' )
matcherTs = CliMatcher.KeywordMatcher( 'ts', helpdesc='Timestamp' )
nodeDebug = CliCommand.Node( matcher=matcherDebug,
      guard=ControllerdbLib.controllerGuard )

#--------------------------------------------------------------------------------
# show cvx debug client ts
#--------------------------------------------------------------------------------
class CvxDebugClientTsCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show cvx debug client ts'
   data = {
      'cvx': showCvxKwMatcher,
      'debug': nodeDebug,
      'client': matcherClient,
      'ts': matcherTs,
   }
   handler = ControllerDebugCli.showServerMountedTs

BasicCli.addShowCommandClass( CvxDebugClientTsCmd )

#--------------------------------------------------------------------------------
# show cvx debug client version
#--------------------------------------------------------------------------------
class CvxDebugClientVersionCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show cvx debug client version'
   data = {
      'cvx': showCvxKwMatcher,
      'debug': nodeDebug,
      'client': matcherClient,
      'version': 'Version of debug client',
   }
   handler = ControllerDebugCli.showClientVersion

BasicCli.addShowCommandClass( CvxDebugClientVersionCmd )

#--------------------------------------------------------------------------------
# show cvx debug pingpong
#--------------------------------------------------------------------------------
class CvxDebugPingpongCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show cvx debug pingpong'
   data = {
      'cvx': showCvxKwMatcher,
      'debug': nodeDebug,
      'pingpong': CliCommand.Node( matcher=matcherPingpong,
         guard=ControllerDebugCli.debugServerGuard ),
   }
   cliModel = PingPongStatus
   handler = ControllerDebugCli.showCvxDebugPingPong

BasicCli.addShowCommandClass( CvxDebugPingpongCmd )

#--------------------------------------------------------------------------------
# show cvx debug server convergencestatus
#--------------------------------------------------------------------------------
class CvxDebugServerConvergencestatusCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show cvx debug server convergencestatus'
   data = {
      'cvx': showCvxKwMatcher,
      'debug': nodeDebug,
      'server': matcherServer,
      'convergencestatus': 'Convergence status for ControllerDebugServer',
   }
   handler = ControllerDebugCli.showCvxDebugConvergenceStatus

BasicCli.addShowCommandClass( CvxDebugServerConvergencestatusCmd )

#--------------------------------------------------------------------------------
# show cvx debug server ts
#--------------------------------------------------------------------------------
class CvxDebugServerTsCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show cvx debug server ts'
   data = {
      'cvx': showCvxKwMatcher,
      'debug': nodeDebug,
      'server': matcherServer,
      'ts': matcherTs,
   }
   handler = lambda mode, args: ControllerDebugCli.printTs(
         ControllerDebugCli.serverLocalTs )

BasicCli.addShowCommandClass( CvxDebugServerTsCmd )

#--------------------------------------------------------------------------------
# show cvx debug server version
#--------------------------------------------------------------------------------
class CvxDebugServerVersionCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show cvx debug server version'
   data = {
      'cvx': showCvxKwMatcher,
      'debug': nodeDebug,
      'server': matcherServer,
      'version': 'Version of debug server',
   }
   handler = ControllerDebugCli.showServerVersion

BasicCli.addShowCommandClass( CvxDebugServerVersionCmd )

#--------------------------------------------------------------------------------
# show management cvx debug client ts
#--------------------------------------------------------------------------------
class ManagementCvxDebugClientTsCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show management cvx debug client ts'
   data = {
      'management': managementShowKwMatcher,
      'cvx': cvxKwMatcherShowMgmt,
      'debug': matcherDebug,
      'client': matcherClient,
      'ts': matcherTs,
   }
   handler = lambda mode, args: ControllerDebugCli.printTs(
         ControllerDebugCli.clientLocalTs )

BasicCli.addShowCommandClass( ManagementCvxDebugClientTsCmd )

#--------------------------------------------------------------------------------
# show management cvx debug pingpong
#--------------------------------------------------------------------------------
class ManagementCvxDebugPingpongCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show management cvx debug pingpong'
   data = {
      'management': managementShowKwMatcher,
      'cvx': cvxKwMatcherShowMgmt,
      'debug': matcherDebug,
      'pingpong': CliCommand.Node( matcher=matcherPingpong,
         guard=ControllerDebugCli.debugClientGuard ),
   }
   cliModel = PingPongStatus
   handler = ControllerDebugCli.showMgmtCvxDebugPingPong

BasicCli.addShowCommandClass( ManagementCvxDebugPingpongCmd )

#--------------------------------------------------------------------------------
# show management cvx debug server ts
#--------------------------------------------------------------------------------
class ManagementCvxDebugServerTsCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show management cvx debug server ts'
   data = {
      'management': managementShowKwMatcher,
      'cvx': cvxKwMatcherShowMgmt,
      'debug': matcherDebug,
      'server': 'Data published from debug server',
      'ts': matcherTs,
   }
   handler = ControllerDebugCli.printPublishedTs

BasicCli.addShowCommandClass( ManagementCvxDebugServerTsCmd )
