# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliModel import Model
from CliModel import Int
from CliModel import Dict
from CliModel import Bool
from CliModel import Float

class EntityStatus( Model ):
   stringBufCount = Int( help="String buffer count" )
   stringBufChurnCount = Int( help="Strung buffer churn count" )

   def render( self ):
      print "    stringBufCount: %d" % self.stringBufCount
      print "    stringBufChurnCount: %d" % self.stringBufChurnCount

class DirStatus( Model ):
   entryCount = Int( help="Entry count" )
   entityChurnCount = Int( help="Entity churn count" )
   entityStatus = Dict( help="Mapping from entity name to status",
                        valueType=EntityStatus, optional=True )

   def render( self ):
      print "  entryCount: %d" % self.entryCount
      print "  entityChurnCount: %d" % self.entityChurnCount
      for name, es in self.entityStatus.iteritems():
         print "  Entity: %s", name
         es.render()

class Dirs( Model ):
   entityChurnCount = Int( help="Entity churn count", optional=True )
   dirChurnCount = Int( help="Dir churn count", optional=True )
   dirStatus = Dict( help="Mapping from dir name to status", valueType=DirStatus,
                     optional=True )

   def render( self ):
      if self.entityChurnCount is not None:
         print "entityChurnCount: %d" % self.entityChurnCount
      if self.dirChurnCount is not None:
         print "dirChurnCount: %d" % self.dirChurnCount
      for name, d in self.dirStatus.iteritems():
         print "Dir:", name
         d.render()

class PingPongStatus( Model ):
   enabled = Bool( help="Ping test is enabled" )
   runTime = Float( help="Total run time (seconds)" )
   totalPings = Int( help="Total pings" )
   addsPerSecond = Int( help="Adds per second" )
   addsPerSecondSnapshot = Int( help="Last adds per second snapshot" )
   delsPerSecond = Int( help="Last deletes per second snapshot", optional=True )
   downtimeCount = Int( help="Number of downtime periods", optional=True )
   longestDowntime = Float( help="Longest downtime (seconds)", optional=True )
   totalDowntime = Float( help="Total downtime (seconds)", optional=True )
   dirChangeCount = Int( help="Number of reactor fires on pingpong directories",
                         optional=True )
   totalDataChangeCount = Int( help="Number of reactor fires on entities in "
                              "pingpong directories", optional=True )

   def render( self ):
      print "Ping test status is: %s" % ( "enabled" if self.enabled else "disabled" )
      print "Total run time (seconds): %s" % self.runTime
      print "Total pings is: %s" % self.totalPings
      print "Adds per second: %s" % self.addsPerSecond
      print "Last adds per second snapshot: %s" % self.addsPerSecondSnapshot
      print "Last deletes per second snapshot: %s" % self.delsPerSecond

      if self.delsPerSecond is not None:
         print "Last deletes per second snapshot: %s" % self.delsPerSecond
      if self.downtimeCount is not None:
         print "Number of downtime periods: %s" % self.downtimeCount
      if self.longestDowntime is not None:
         print "Longest downtime (seconds): %s" % self.longestDowntime
      if self.totalDowntime is not None:
         print "Total downtime (seconds): %s" % self.totalDowntime
      if self.dirChangeCount is not None:
         print "Number of reactor fires on pingpong directories: %s" % \
               self.dirChangeCount
      if self.totalDataChangeCount is not None:
         print "Number of reactor fires on entities in pingpong directories: %s" % \
               self.totalDataChangeCount
