#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCliModes
import CliCommand
import CliMatcher
import CliPlugin.ControllerClient as ControllerClient
from CliPlugin.ConfigMgmtMode import managementKwMatcher
from IpLibConsts import DEFAULT_VRF

#--------------------------------------------------------------------------------
# [ no | default ] management cvx [ CVX ]
#--------------------------------------------------------------------------------
class ManagementCvxCmd( CliCommand.CliCommandClass ):
   syntax = 'management cvx [ CVX ]'
   noOrDefaultSyntax = syntax
   data = {
      'management': managementKwMatcher,
      'cvx': 'Configure CVX client',
      'CVX':
         CliMatcher.DynamicNameMatcher(
            lambda mode: [ ControllerClient.clientConfig.clusterName ],
            'CVX cluster name' ),
   }
   
   @staticmethod
   def handler( mode, args ):
      clusterName = args.get( 'CVX' ) or ControllerClient.clusterDefaultName
      clientConfig = ControllerClient.clientConfig
      if clientConfig.clusterName and \
            clientConfig.clusterName != clusterName:
         mode.addError( "CVX already configured for cluster %s. CVX client cannot "
                        "connect to multiple clusters." %
                        clientConfig.clusterName )
         return
      childMode = mode.childMode( ControllerClient.CvxMgmtConfigMode,
            clusterName=clusterName )
      mode.session_.gotoChildMode( childMode )
      clientConfig.clusterName = clusterName

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      clusterName = args.get( 'CVX' )
      clientConfig = ControllerClient.clientConfig
      if clusterName and clientConfig.clusterName != clusterName:
         mode.addWarning( "CVX cluster %s does not exist" % clusterName )
         return
      clientConfig.enabled = False
      clientConfig.clusterName = ""
      clientConfig.controllerConfig.clear()
      clientConfig.switchHost.sourceIntf = ControllerClient.defaultSourceIntf
      clientConfig.switchHost.vrfName = DEFAULT_VRF
      hbc = clientConfig.heartbeatConfig
      hbc.punchInterval = ControllerClient.heartbeatIntervalType.defaultVal
      hbc.timeout = ControllerClient.heartbeatTimeoutType.defaultVal
      clientConfig.sslProfileConfig.sslProfileName = ""
      ControllerClient.runNoMgmtCvxCallbacks( mode )

BasicCliModes.GlobalConfigMode.addCommandClass( ManagementCvxCmd )
