# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import LazyMount
import ConfigMount
import CliGlobal
import CliParser
import CliMatcher
import CliPlugin.IntfCli
import CliPlugin.TechSupportCli
from CliPlugin import ConfigMgmtMode

clientStatus = None
clientConfig = None
ipConfig = None
ipStatus = None
sysdbStatus = None
sysdbConfig = None
mgmtSecConfig = None
defaultSourceIntf = Tac.Value( "Arnet::IntfId" )

heartbeatIntervalType = Tac.Type( "Controller::Heartbeat::Interval" )
heartbeatTimeoutType =  Tac.Type( "Controller::Heartbeat::Timeout" )
constants = Tac.Value( "Controller::Constants" )
clusterDefaultName = constants.clusterDefaultName

cvxKwMatcherShowMgmt = CliMatcher.KeywordMatcher( 'cvx', helpdesc='Show CVX status' )

# Services can register a cleanup function to be executed everytime the command
# 'no management cvx' is executed. That way, running 'no management cvx' will 
# disable all configurable services. Each registered function will be called 
# with the cli mode as argument.
_noMgmtCvxHook = []
def addNoMgmtCvxCallback( fn ):
   assert callable( fn )
   _noMgmtCvxHook.append( fn )

def runNoMgmtCvxCallbacks( mode ):
   for fn in _noMgmtCvxHook:
      fn( mode )

class CvxMgmtConfigMode( ConfigMgmtMode.ConfigMgmtMode ):
   name = "CVX configuration"
   modeParseTree = CliParser.ModeParseTree()

   def __init__( self, parent, session, clusterName=None ):
      self.clusterName = clusterName or clusterDefaultName
      cvxModeName = ( 'cvx' if self.clusterName == clusterDefaultName else
                      'cvx-%s' % self.clusterName )
      ConfigMgmtMode.ConfigMgmtMode.__init__( self, parent, session, cvxModeName )

   def enterCmd( self ):
      return ( "management cvx %s" % self.clusterName ) if \
            self.clusterName != clusterDefaultName else "management cvx"

#------------------------------------------------------------------------------
# Register tech-support commands
#------------------------------------------------------------------------------
def _showTechCmds():
   cmds = [ "show management cvx",
            "show management cvx service",
            ]
   return cmds
timestamp = '2014-01-13 11:59:35'
CliPlugin.TechSupportCli.registerShowTechSupportCmdCallback(
      timestamp, _showTechCmds )

# Hook for secondarySysdbConfig and secondarySysdbStatus
# that comes from MCS
gv = CliGlobal.CliGlobal(
      dict(
         secondaryClientConfig=None,
         secondaryClientStatus=None,
         secondarySysdbConfig=None,
         secondarySysdbStatus=None ) )
def enableSecondaryCvxHook(
      secondaryClientConfig,
      secondaryClientStatus,
      secondarySysdbConfig, 
      secondarySysdbStatus ):
   gv.secondaryClientConfig = secondaryClientConfig
   gv.secondaryClientStatus = secondaryClientStatus
   gv.secondarySysdbConfig = secondarySysdbConfig
   gv.secondarySysdbStatus = secondarySysdbStatus

def Plugin( entityManager ):
   global clientStatus
   global clientConfig
   global ipConfig, ipStatus
   global sysdbStatus
   global sysdbConfig
   global mgmtSecConfig
   
   clientConfig = ConfigMount.mount( entityManager, "mgmt/controller/config",
                                         "ControllerClient::Config", "w" )
   clientStatus = LazyMount.mount( entityManager, "mgmt/controller/status",
                                           "ControllerClient::Status", "r" )
   ipConfig = ConfigMount.mount( entityManager, "ip/config",
                                 "Ip::Config", "w" )
   ipStatus = LazyMount.mount( entityManager, "ip/status", "Ip::Status", "r" )
   sysdbStatus = LazyMount.mount( entityManager, "mgmt/controller/publish/status",
                                    "ControllerClient::SysdbStatus", "r" )
   sysdbConfig = LazyMount.mount( entityManager, 
                                 "mgmt/controller/publish/config",
                                 "ControllerClient::SysdbConfig",
                                 "r" )
   mgmtSecConfig = ConfigMount.mount( entityManager, "mgmt/security/ssl/config",
                                      "Mgmt::Security::Ssl::Config", "w" )

