# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCli
import BasicCliModes
import CliCommand
import CliMatcher
import CliToken.Configure
import CliToken.Clear
import CliPlugin.ConfigLockCli
import CliPlugin.ConfigLockModels
import CliPlugin.TechSupportCli
import ShowCommand

configKwMatcher = CliMatcher.KeywordMatcher(
   'configuration',
   helpdesc='Show configuration information' )

class ShowConfigureLockCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show configuration lock'
   data = {
            'configuration': configKwMatcher,
            'lock': 'Configure lock information',
          }
   cliModel = CliPlugin.ConfigLockModels.ConfigureLockModel
   handler = CliPlugin.ConfigLockCli.showConfigLockHandler

class ShowConfigureLockHistoryCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show configuration lock history'
   data = {
            'configuration': configKwMatcher,
            'lock': 'Configure lock information',
            'history': 'Show past lock owners'
          }
   cliModel = CliPlugin.ConfigLockModels.ConfigureLockModelHistory
   handler = CliPlugin.ConfigLockCli.showConfigLockHistoryHandler

CliPlugin.TechSupportCli.registerShowTechSupportCmdCallback(
                                '2019-09-03 17:15:10',
                                lambda: [ 'show configuration lock history' ] )

class ConfigureLockCmd( CliCommand.CliCommandClass ):
   syntax = 'configure lock [ REASON ]'
   data = {
            'configure': CliToken.Configure.configureParseNode,
            'lock': 'Acquire the configure lock',
            'REASON': CliMatcher.StringMatcher( helpname='REASON',
               helpdesc='Reason for acquiring the lock' )
          }
   handler = CliPlugin.ConfigLockCli.configureLockCmdHandler

class ConfigureUnlockCmd( CliCommand.CliCommandClass ):
   syntax = 'configure unlock'
   data = {
            'configure': CliToken.Configure.configureParseNode,
            'unlock': 'Remove the configure lock'
          }
   handler = CliPlugin.ConfigLockCli.configureUnlockCmdHandler

class ConfigureUnlockForceCmds( CliCommand.CliCommandClass ):
   syntax = 'configure unlock force [ REASON ]'
   data = {
            'configure': CliToken.Configure.configureParseNode,
            'unlock': 'Remove the configure lock',
            'force': 'Force releasing the configure lock',
            'REASON': CliMatcher.StringMatcher( helpname='REASON',
               helpdesc='Reason for releasing the lock' )
          }
   handler = CliPlugin.ConfigLockCli.configureUnlockForceCmdHandler

BasicCli.addShowCommandClass( ShowConfigureLockCmd )
BasicCli.addShowCommandClass( ShowConfigureLockHistoryCmd )

# only add the commands to enable mode, and not unpriv mode
BasicCliModes.EnableMode.addCommandClass( ConfigureLockCmd )
BasicCliModes.EnableMode.addCommandClass( ConfigureUnlockCmd )
BasicCliModes.EnableMode.addCommandClass( ConfigureUnlockForceCmds )
