# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import operator

import Tac
from CliModel import Model, Str, Dict
from CloudHaModel import _getStr, showCloudTableFormat
from TableOutput import Format, FormattedCell, createTable

# Cli Model for "show cloud provider aws"
class CloudAws( Model ):
   # Configuration
   region = Str( help="AWS region" )
   accessKey = Str( help="AWS access key" )
   secretKey = Str( help="AWS secret key" )
   proxy = Str( help="Proxy name", optional=True )

   def render( self ):
      t = showCloudTableFormat()
      headerFormat = Format( justify="left", noBreak=True, terminateRow=True )
      headerFormat.noPadLeftIs( True )
      headerFormat.padLimitIs( True )
      headerFormat.noTrailingSpaceIs( True )
      t.newRow( FormattedCell( content="Cloud AWS Configuration:", nCols=1,
                               format=headerFormat ) )

      for ( label, value ) in (
         ( "Region", _getStr( self.region ) ),
         ( "Access key ID ", _getStr( self.accessKey ) ),
         ( "Access secret key", _getStr( self.secretKey ) ),
         ( "Proxy", _getStr( self.proxy, '') ),
         ):
         if value is not None:
            t.newRow( label, " : ", value )

      print t.output()

class AwsRoute( Model ):
   nextHop = Str( help='Next hop interface' )

# Key type should be IpAddrAndMask but it is not supported by CliModel.
# Use str for now.
class AwsRouteTable(Model ):
   routes = Dict( valueType=AwsRoute,
            help='str(IpAddAndMask) to Route' )

# Cli Model for "show cloud ha routes"
class AwsCloudHaRoutes( Model ):
   peerName = Str( help='PeerName', optional=True )
   localRoutes = Dict( valueType=AwsRouteTable, keyType=str,
                     help='Route table ID to routeTable' )
   peerRoutes = Dict( valueType=AwsRouteTable, keyType=str,
                     help='Route Table ID to routeTable' )

   def render( self ):
      headerFormat = Format( justify="left", noBreak=True, terminateRow=True )
      headerFormat.noPadLeftIs( True )
      headerFormat.padLimitIs( True )
      headerFormat.noTrailingSpaceIs( True )
      t = createTable( ( "Peer", "Route Type",
         "Route ID", "Destination", "Next Hop Interface"  ) )
      sortedDict = sorted( self.localRoutes.items(), key=operator.itemgetter( 0 ) )
      for rt, val in sortedDict:
         sortedRoutes = sorted( val.routes.items(), key=operator.itemgetter( 0 ) )
         for dest, route in sortedRoutes:
            t.newRow( self.peerName, 'primary', rt, dest, route.nextHop )

      sortedDict = sorted( self.peerRoutes.items(), key=operator.itemgetter( 0 ) )
      for rt, val in sortedDict:
         sortedRoutes = sorted( val.routes.items(), key=operator.itemgetter( 0 ) )
         for dest, route in sortedRoutes:
            t.newRow( self.peerName, 'backup', rt, dest, route.nextHop )
      print t.output()


