#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import CliCommand
import CliMatcher
import CliMode.CloudHaModes
import CliPlugin.CloudHaCliLib as CloudHaCliLib
from Tracing import t0

#--------------------------------------------------------------------------------
# [ no | default ] peer PEER
#--------------------------------------------------------------------------------
class PeerPeernameCmd( CliCommand.CliCommandClass ):
   syntax = 'peer PEER'
   noOrDefaultSyntax = syntax
   data = {
      'peer' : 'Cloud HA Peer config submode',
      'PEER' : CliMatcher.PatternMatcher( pattern=CloudHaCliLib.lettersThenAnything,
                                          helpdesc='Peer name to configure',
                                          helpname='WORD' ),
   }

   @staticmethod
   def handler( mode, args ):
      peerName = args[ 'PEER' ]
      if CliMode.CloudHaModes.cloudConfig:
         for i in CliMode.CloudHaModes.cloudConfig.peer.values():
            # We allow only a single peer for now.
            # FIXME: Should this be `mode.addError`?
            if i.name != peerName:
               print( '! Peer %s already exists. Only one Cloud HA peer supported.'
                      % i.name )
               return
      childMode = mode.childMode( CliMode.CloudHaModes.ConfigCloudHaPeerMode,
                                  peerName=peerName )
      t0( 'Entering peer mode with peer =', peerName )
      mode.session_.gotoChildMode( childMode )

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      peerName = args[ 'PEER' ]
      t0( 'no HA Peer mode', peerName )
      if peerName not in mode.config.peer:
         t0( "peer config not found for peer:", peerName )
      else:
         del mode.config.peer[ peerName ]
      assert peerName not in mode.config.peer

      # Unfortunately the TAC model is little messed up as
      # the local/peer routes should be within a peer but
      # since we don't support multiple peers and no intention
      # to support in near term, we keep these globally.
      # This was done to keep possibility of a future Cli future
      # extention open.
      mode.config.localRoutes.clear()
      mode.config.peerRoutes.clear()
      mode.changed = True
      t0( "Removed peer config" , peerName )

CliMode.CloudHaModes.ConfigCloudHaMode.addCommandClass( PeerPeernameCmd )

#--------------------------------------------------------------------------------
# [ no | default ] shutdown
#--------------------------------------------------------------------------------
class ShutdownCmd( CliCommand.CliCommandClass ):
   syntax = 'shutdown'
   noOrDefaultSyntax = syntax
   data = {
      'shutdown' : 'Disable Cloud High Availability',
   }

   @staticmethod
   def handler( mode, args ):
      # Reverse logic, since it's 'no shutdown'. Off by default.
      enable = CliCommand.isNoCmd( args )
      t0( "Enabling Cloud ha: ", enable )
      mode.enable = enable

   noOrDefaultHandler = handler

CliMode.CloudHaModes.ConfigCloudHaMode.addCommandClass( ShutdownCmd )
