# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import CliCommand
import CliMatcher
import CliMode.CloudHaModes as CloudHaModes
import CliPlugin.CloudHaCliLib as CloudHaCliLib
from CliPlugin.EthIntfCli import EthPhyIntf
import Tac
from Tracing import t0

#-------------------------------------------------------------------------------
# config-cloud-ha# [ no | default ] ( primary-gateway | backup-gateway )
#    PREFIX [ ( interface INTF ) | ( vpc VPC ) ] [ tag TAG ] command
#-------------------------------------------------------------------------------
class PrimaryOrBackupGatewayCmd( CliCommand.CliCommandClass ):
   syntax = ( '( primary-gateway | backup-gateway ) PREFIX '
         '[ ( interface INTF ) | ( vpc VPC ) ] [ tag TAG ]' )
   noOrDefaultSyntax = syntax
   data = {
         'primary-gateway': 'Local routes',
         'backup-gateway': 'Backup routes for the peer',
         'PREFIX': CloudHaCliLib.matcherRoute,
         'interface': 'Route interface',
         'INTF': EthPhyIntf.ethMatcher,
         'vpc': 'Route VPC',
         'VPC': CliMatcher.PatternMatcher(
            pattern=r'[a-z]([a-z0-9\-]{0,61}[a-z0-9])?',
            helpdesc='VPC name', helpname='WORD' ),
         'tag': 'GCP route tag',
         'TAG': CliMatcher.PatternMatcher(
            pattern=r'[a-z]([a-z0-9\-]{0,61}[a-z0-9])?',
            helpdesc='Route tag', helpname='WORD' ),
   }

   @staticmethod
   def handler( mode, args ):
      ipAddrWithMask = args[ 'PREFIX' ]
      interface = args.get( 'INTF' )
      interface = Tac.Value( 'Arnet::IntfId', interface.name if interface else '' )
      vpc = args.get( 'VPC', '' )
      tag = args.get( 'TAG', '' )
      gcpRoute = Tac.newInstance( "Cloud::HA::GcpRoute", interface, vpc,
            ipAddrWithMask, tag)

      if 'primary-gateway' in args:
         routes = CloudHaModes.gcpCloudConfig.localRoutes
      elif 'backup-gateway' in args:
         routes = CloudHaModes.gcpCloudConfig.peerRoutes

      ## Make sure it is not there or update change flag.
      if gcpRoute not in routes:
         t0( "Updating route", gcpRoute )
         mode.changed = True
      routes.add( gcpRoute )

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      ipAddrWithMask = args[ 'PREFIX' ]
      interface = args.get( 'INTF' )
      interface = Tac.Value( 'Arnet::IntfId', interface.name if interface else '' )
      vpc = args.get( 'VPC', '' )
      tag = args.get( 'TAG', '' )
      gcpRoute = Tac.newInstance( "Cloud::HA::GcpRoute", interface, vpc,
            ipAddrWithMask, tag)

      if 'primary-gateway' in args:
         routes = CloudHaModes.gcpCloudConfig.localRoutes
      elif 'backup-gateway' in args:
         routes = CloudHaModes.gcpCloudConfig.peerRoutes

      if gcpRoute in routes:
         t0( "Removed entry from localRouteTable" )
         mode.changed = True
      routes.remove( gcpRoute )

CloudHaModes.ConfigCloudHaGcpMode.addCommandClass( PrimaryOrBackupGatewayCmd )
