#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import CliCommand
import CliMatcher
import CliMode.CloudHaModes
import CliPlugin.CloudHaCliLib as CloudHaCliLib
import Tac
from Tracing import t0

#--------------------------------------------------------------------------------
# [ no | default ] ( primary-gateway | backup-gateway )
#                  TABLE ROUTE local-cloud-interface INTF
#--------------------------------------------------------------------------------
class PrimaryGatewayAwsrtidCmd( CliCommand.CliCommandClass ):
   syntax = ( '( primary-gateway | backup-gateway ) '
              'TABLE ROUTE local-cloud-interface INTF' )
   noOrDefaultSyntax = '( primary-gateway | backup-gateway ) TABLE ROUTE ...'
   data = {
      'primary-gateway' : CloudHaCliLib.matcherPrimaryGateway,
      'backup-gateway' : CloudHaCliLib.matcherBackupGateway,
      'TABLE' : CliMatcher.PatternMatcher( pattern=CloudHaCliLib.lettersThenAnything,
                                           helpdesc='AWS route table ID',
                                           helpname='WORD' ),
      'ROUTE' : CloudHaCliLib.matcherRoute,
      'local-cloud-interface' : 'AWS route target',
      'INTF' : CliMatcher.PatternMatcher( pattern=CloudHaCliLib.lettersThenAnything,
                                          helpdesc='AWS network interface ID '
                                                   'of this EOS instance ',
                                          helpname='WORD' ),
   }

   @staticmethod
   def handler( mode, args ):
      awsRtId = args[ 'TABLE' ]
      ipAddrWithMask = args[ 'ROUTE' ]
      rtTarget = args[ 'INTF' ]
      rtIdAndDestKey = Tac.newInstance( "Cloud::HA::RouteTableDestKey",
                                        awsRtId, ipAddrWithMask )
      rtIdAndDest = Tac.newInstance( "Cloud::HA::AwsRoute", rtIdAndDestKey )
      rtIdAndDest.nextHopRouteTarget = rtTarget

      primary = 'primary-gateway' in args
      if primary:
         routes = CliMode.CloudHaModes.awsCloudConfig.localRoutes
      else:
         routes = CliMode.CloudHaModes.awsCloudConfig.peerRoutes

      ## Make sure it is not there or update change flag.
      val = routes.get( rtIdAndDestKey )
      if not val or val.nextHopRouteTarget != rtTarget:
         t0(" Updating local =", primary, "RouteTable", rtTarget, val )
         mode.changed = True

      routes.addMember( rtIdAndDest )

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      awsRtId = args[ 'TABLE' ]
      ipAddrWithMask = args[ 'ROUTE' ]
      primary = 'primary-gateway' in args

      if primary:
         routes = CliMode.CloudHaModes.awsCloudConfig.localRoutes
      else:
         routes = CliMode.CloudHaModes.awsCloudConfig.peerRoutes

      t0( "Reseting  local =", primary,
          "route for ", awsRtId, ipAddrWithMask.__class__ )
      rtIdAndDestKey = Tac.newInstance( "Cloud::HA::RouteTableDestKey",
            awsRtId, ipAddrWithMask )
      if rtIdAndDestKey in routes:
         t0( " Removed entry from localRouteTable" )
         mode.changed = True
      del routes[ rtIdAndDestKey ]

CliMode.CloudHaModes.ConfigCloudHaAwsMode.addCommandClass( PrimaryGatewayAwsrtidCmd )
