#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import CliCommand
import CliMatcher
import CliPlugin.CloudHaCliLib as CloudHaCliLib
import Url
from CliMode.CloudHaModes import ConfigCloudAzureMode
from Tracing import t0

#--------------------------------------------------------------------------------
# [ no | default ] proxy PROXY
#--------------------------------------------------------------------------------
class ProxyCmd( CliCommand.CliCommandClass ):
   syntax = 'proxy PROXY'
   noOrDefaultSyntax = 'proxy ...'
   data = {
      'proxy': CloudHaCliLib.matcherProxy,
      'PROXY': CloudHaCliLib.matcherProxyValue,
   }

   @staticmethod
   def handler( mode, args ):
      CloudHaCliLib.setProxy( mode, mode.accessConfig, args[ 'PROXY' ] )

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      CloudHaCliLib.noProxy( mode, mode.accessConfig )

ConfigCloudAzureMode.addCommandClass( ProxyCmd )

#--------------------------------------------------------------------------------
# [ no | default ] sdk authentication credential-file FILE
#--------------------------------------------------------------------------------
class SdkAuthCredentialFileCmd( CliCommand.CliCommandClass ):
   syntax = 'sdk authentication credential-file FILE'
   noOrDefaultSyntax = 'sdk authentication credential-file ...'
   data = {
      'sdk' : 'Azure SDK specific configuration',
      'authentication' : 'SDK authentication',
      'credential-file' : 'Credential file location',
      'FILE' : Url.UrlMatcher( fsFunc=lambda fs: fs.fsType == 'flash',
                               helpdesc='Credential file URL' ),

   }

   @staticmethod
   def handler( mode, args ):
      fileLoc = args[ 'FILE' ]
      t0( 'Got token', fileLoc, 'in sdkAuthFile, mode', mode )
      mode.accessConfig.sdkcredFileLocation = fileLoc.url

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      t0( 'Got no token in no , mode',  mode )
      mode.accessConfig.sdkcredFileLocation = ''

ConfigCloudAzureMode.addCommandClass( SdkAuthCredentialFileCmd )

#-------------------------------------------------------------------------------
# config-cloud-azure# [ no | default ] active-directory credential EMAIL
#                                      subscription-id ID PASSWORD
#-------------------------------------------------------------------------------
class ActiveDirectoryCommand( CliCommand.CliCommandClass ):
   syntax = ( 'active-directory credential EMAIL '
              'subscription-id ID PASSWORD' )
   noOrDefaultSyntax = 'active-directory credential ...'
   data = {
      'active-directory' : 'Active directory',
      'credential' : 'Active directory credential',
      'EMAIL' : CliMatcher.PatternMatcher( pattern=CloudHaCliLib.lettersThenAnything,
                                           helpname='EMAIL',
                                           helpdesc='Azure credential email' ),
      'subscription-id' : 'Active directory subscription ID',
      'ID' : CliMatcher.PatternMatcher( pattern=CloudHaCliLib.lettersThenAnything,
                                        helpname='WORD',
                                        helpdesc='Subscription ID' ),
      'PASSWORD' : CloudHaCliLib.passwordExpr,
   }
   @staticmethod
   def handler( mode, args ):
      email = args[ 'EMAIL' ]
      password = args[ 'PASSWORD' ]
      subsId = args[ 'ID' ]
      t0( 'Email', email, ', password', password,
          ', subscriptionId', subsId, ', in mode', mode )
      mode.accessConfig.adEmail = email
      mode.accessConfig.password = password
      mode.accessConfig.subscriptionId = subsId

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      t0( 'Got no token in mode:', mode )
      mode.accessConfig.adEmail = ''
      mode.accessConfig.password = ''
      mode.accessConfig.subscriptionId = ''

ConfigCloudAzureMode.addCommandClass( ActiveDirectoryCommand )
