#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import CliCommand
import CliMatcher
import CliMode.CloudHaModes
import CliPlugin.CloudHaCliLib as CloudHaCliLib
from Tracing import t0

#--------------------------------------------------------------------------------
# [ no | default ] proxy PROXY
#--------------------------------------------------------------------------------
class ProxyCmd( CliCommand.CliCommandClass ):
   syntax = 'proxy PROXY'
   noOrDefaultSyntax = 'proxy ...'
   data = {
      'proxy': CloudHaCliLib.matcherProxy,
      'PROXY': CloudHaCliLib.matcherProxyValue,
   }

   @staticmethod
   def handler( mode, args ):
      CloudHaCliLib.setProxy( mode, mode.awsConfig, args[ 'PROXY' ] )

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      CloudHaCliLib.noProxy( mode, mode.awsConfig )

CliMode.CloudHaModes.ConfigCloudAwsMode.addCommandClass( ProxyCmd )

#--------------------------------------------------------------------------------
# [ no | default ] region REGION
#--------------------------------------------------------------------------------
class RegionCmd( CliCommand.CliCommandClass ):
   syntax = 'region REGION'
   noOrDefaultSyntax = 'region ...'
   data = {
      'region' : 'AWS region',
      'REGION' : CliMatcher.PatternMatcher(
                    pattern=CloudHaCliLib.lettersThenAnything,
                    helpdesc='AWS region name',
                    helpname='WORD' ),
   }

   @staticmethod
   def handler( mode, args ):
      region = args[ 'REGION' ]
      t0( 'got token', region, 'in mode', mode )
      mode.awsConfig.region = region

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      t0( 'got no token in aws mode',  mode)
      mode.awsConfig.region = ''

CliMode.CloudHaModes.ConfigCloudAwsMode.addCommandClass( RegionCmd )

#-------------------------------------------------------------------------------
# config-cloud-aws# [ no | default ] access-key-id PASSWORD
#-------------------------------------------------------------------------------
class AccessKeyCommand( CliCommand.CliCommandClass ):
   syntax = 'access-key-id PASSWORD'
   noOrDefaultSyntax = 'access-key-id ...'
   data = {
      'access-key-id' : 'AWS access key',
      'PASSWORD' : CloudHaCliLib.passwordExpr,
   }

   @staticmethod
   def handler( mode, args ):
      accessKey = args[ 'PASSWORD' ]
      t0( 'Got token', accessKey, 'in mode', mode )
      mode.awsConfig.accessKey = accessKey

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      t0( 'got no token in mode ', mode )
      mode.awsConfig.accessKey = ''

CliMode.CloudHaModes.ConfigCloudAwsMode.addCommandClass( AccessKeyCommand )

#-------------------------------------------------------------------------------
# config-cloud-aws# [ no | default ] secret access-key PASSWORD
#-------------------------------------------------------------------------------
class SecretAccessKeyCommand( CliCommand.CliCommandClass ):
   syntax = 'secret access-key PASSWORD'
   noOrDefaultSyntax = 'secret access-key ...'
   data = {
      'secret' : 'AWS secret',
      'access-key' : 'AWS secret access key',
      'PASSWORD' : CloudHaCliLib.passwordExpr,
   }
   @staticmethod
   def handler( mode, args ):
      secretAccessKey = args[ 'PASSWORD' ]
      t0( 'Got token', secretAccessKey, 'in mode', mode )
      mode.awsConfig.secretAccess = secretAccessKey

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      t0( 'Got no token in mode', mode )
      mode.awsConfig.secretAccess = ''

CliMode.CloudHaModes.ConfigCloudAwsMode.addCommandClass( SecretAccessKeyCommand )
