# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import CliCommand
import CliMatcher
import CliMode.CloudHaModes
import CliParser
import ConfigMount
import ReversibleSecretCli
from CliPlugin.IpAddrMatcher import ipAddrWithMaskExpr
from CloudUtil import getHypervisor
from Tracing import t0

lettersThenAnything = r'[a-zA-Z]+.*'

cloudType = getHypervisor()
providerProxyHandlerFuncs = []
proxyConfig = None

def providerProxyHandler( handlerFunc ):
   providerProxyHandlerFuncs.append( handlerFunc )
   return handlerFunc

def updateCloudHaProxy( proxyName ):
   t0( 'updateCloudHaProxy: proxy', proxyName )
   return any( f( proxyName ) for f in providerProxyHandlerFuncs )

def cloudHaSupportedGuard( mode, token ):
   if not cloudType:
      return CliParser.guardNotThisPlatform
   return None

def cloudAwsSupportedGuard( mode, token ):
   if cloudType != "AWS" :
      return CliParser.guardNotThisPlatform
   return None

def cloudAzureSupportedGuard( mode, token ):
   if cloudType != "Azure" :
      return CliParser.guardNotThisPlatform
   return None

def cloudGcpSupportedGuard( mode, token ):
   if cloudType != 'GCP':
      return CliParser.guardNotThisPlatform
   return None

matcherBackupGateway = CliMatcher.KeywordMatcher( 'backup-gateway',
      helpdesc='Backup routes for the peer' )
matcherHighAvailability = CliMatcher.KeywordMatcher( 'high-availability',
      helpdesc='Cloud High Availability' )
matcherPrimaryGateway = CliMatcher.KeywordMatcher( 'primary-gateway',
      helpdesc='Local route tables' )
matcherProvider = CliMatcher.KeywordMatcher( 'provider',
      helpdesc='Cloud provider' )
matcherProxy = CliMatcher.KeywordMatcher( 'proxy',
      helpdesc='Proxy' )
matcherProxyValue = CliMatcher.PatternMatcher( pattern=lettersThenAnything,
      helpdesc='Proxy name',
      helpname='WORD' )
matcherRoute = ipAddrWithMaskExpr( addrdesc='Destination address',
      maskdesc='Mask',
      prefixdesc='Route prefix' )
nodeAws = CliCommand.guardedKeyword( 'aws',
      helpdesc='AWS configuration',
      guard=cloudAwsSupportedGuard )
nodeAzure = CliCommand.guardedKeyword( 'azure',
      helpdesc='Azure configuration',
      guard=cloudAzureSupportedGuard )
nodeCloud = CliCommand.guardedKeyword( 'cloud',
      helpdesc='Cloud configuration',
      guard=cloudHaSupportedGuard )
nodeGcp = CliCommand.guardedKeyword( 'gcp',
      helpdesc='GCP configuration',
      guard=cloudGcpSupportedGuard )
passwordExpr = ReversibleSecretCli.reversibleSecretCliExpression( 'PASSWORD' )

#-------------------------------------------------------------------------------
# config-cloud-azure# [ no | default ] proxy PROXY comand
# config-cloud-aws#   [ no | default ] proxy PROXY comand
# config-cloud-gcp#   [ no | default ] proxy PROXY comand
#-------------------------------------------------------------------------------
def setProxy( mode, config, proxy ):
   t0( 'Got token', proxy, 'in proxy, mode', mode )
   pr = proxyConfig.proxy.get( proxy )
   if not pr:
      t0( '!proxy', proxy, 'is not configured' )
   # Still accept it as the config order may have changed
   config.proxyName = proxy

def noProxy( mode, config ):
   t0( 'Got no token in no proxy, mode',  mode )
   config.proxyName = ''

def Plugin( entityManager ):
   global proxyConfig

   proxyConfig = ConfigMount.mount( entityManager, 'cloudha/proxyConfig',
         'Cloud::HA::ProxyConfig', 'w' )

   CliMode.CloudHaModes.proxyConfig = proxyConfig
