# Copyright (c) 2006-2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

# This module implements the 'show error <n>' command, which displays the details of
# an uncaught exception that was raised by the CLI.

import os
import os.path

import BasicCli
import CliCommon
import CliMatcher
import ShowCommand
import Tac

#------------------------------------------------------------------------------------
# show error <num>
# -----------------------------------------------------------------------------------
class ShowError( ShowCommand.ShowCliCommandClass ):
   syntax = 'show error <num>'
   data = { 'error': 'Show detailed information about an earlier error',
            '<num>': CliMatcher.IntegerMatcher( 0, 999999, helpdesc='Error number' )
   }

   @staticmethod
   def handler( mode, args ):
      num = args[ '<num>' ]
      logFilename = os.path.join( CliCommon.getCliLogDir(), 'err-%06d.log' % num )
      if not os.access( logFilename, os.R_OK ):
         mode.addError( 'No log file for error %d' % num )
         return

      with open( logFilename ) as f:
         print( f.read() )

BasicCli.addShowCommandClass( ShowError )
