#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Ark

@Ark.synchronized()
def updateAppProfileId( appProfileIdMap, appProfileName, add=True ):
   '''
   @appProfileIdMap: Sysdb path for Classification::AppProfileIdMap
   @appProfileName: Application-profile name
   @add: True gives a new ID if it doesn't exist, False deletes an existing ID.

   If True, return the ID if appProfileName exist in nameToId map otherwise
   assign a new ID for appProfileName.
   Return 0, if no free ID is available.

   If False, then deletes the ID associated with name.
   '''
   appProfileId = 0
   if add:
      # Return ID if it already exist
      if appProfileName in appProfileIdMap.nameToId:
         appProfileId = appProfileIdMap.nameToId[ appProfileName ]

      # assign a new ID from free pool
      elif len( appProfileIdMap.freeIds ) >= 1:
         # Get the lowest available ID
         appProfileId = appProfileIdMap.freeIds.keys()[ 0 ]
         # Remove ID from free pool
         del appProfileIdMap.freeIds[ appProfileId ]
         # update Map
         appProfileIdMap.idToName[ appProfileId ] = appProfileName
         appProfileIdMap.nameToId[ appProfileName ] = appProfileId

   else:
      if appProfileName in appProfileIdMap.nameToId:
         appProfileId = appProfileIdMap.nameToId[ appProfileName ]
         appProfileIdMap.freeIds[ appProfileId ] = True
         del appProfileIdMap.nameToId[ appProfileName ]
         del appProfileIdMap.idToName[ appProfileId ]
   return appProfileId
