#!/usr/bin/env python
# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliCommand
import CliParser
import ConfigMount
import LazyMount
import Plugins
from CliMode.BugAlert import BugAlertConfigModeBase
from CliPlugin.ControllerCli import (CvxConfigMode, addNoCvxCallback,
                                     serviceKwMatcher)

controllerConfig = None
serviceCfgDir = None
bugAlertConfig = None

#-------------------------------------------------------------------------------
# Service BugAlert config
#-------------------------------------------------------------------------------
class BugAlertConfigMode( BugAlertConfigModeBase, BasicCli.ConfigModeBase ):
   name = 'BugAlert configuration'
   modeParseTree = CliParser.ModeParseTree()

   def __init__( self, parent, session ):
      BugAlertConfigModeBase.__init__( self )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class EnterBugAlertMode( CliCommand.CliCommandClass ):
   syntax = """service bug-alert"""
   data = { "service" : serviceKwMatcher,
            "bug-alert" : "Configure BugAlert Service" }

   @staticmethod
   def handler( mode, args ):
      childMode = mode.childMode( BugAlertConfigMode )
      mode.session_.gotoChildMode( childMode )

CvxConfigMode.addCommandClass( EnterBugAlertMode )

def enableBugAlertService( mode ):
   bugAlertServiceConfig = serviceCfgDir.service[ "BugAlert" ]
   bugAlertServiceConfig.enabled = True
   bugAlertConfig.enabled = True

def disableBugAlertService( mode ):
   bugAlertServiceConfig = serviceCfgDir.service[ "BugAlert" ]
   bugAlertServiceConfig.enabled = False
   bugAlertConfig.enabled = False

class ShutDownCommand( CliCommand.CliCommandClass ):
   syntax = """shutdown"""
   noOrDefaultSyntax = """shutdown"""
   data = { "shutdown" : "Shutdown BugAlert service" }

   @staticmethod
   def handler( mode, args ):
      disableBugAlertService( mode )

   @staticmethod
   def defaultHandler( mode, args ):
      disableBugAlertService( mode )

   @staticmethod
   def noHandler( mode, args ):
      enableBugAlertService( mode )

BugAlertConfigMode.addCommandClass( ShutDownCommand )

addNoCvxCallback( disableBugAlertService )

@Plugins.plugin( requires=( "ControllerdbMgr", ) )
def Plugin( entityManager ):
   global controllerConfig
   global serviceCfgDir
   global bugAlertConfig

   controllerConfig = LazyMount.mount( entityManager,
                                       "controller/config",
                                       "Controllerdb::Config", "r" )

   # To let the CVX infrastructure to know that BugAlert service is enabled/disabled
   serviceCfgDir = ConfigMount.mount( entityManager,
                                      "controller/service/config",
                                      "Controller::ServiceConfigDir", "w" )

   bugAlertConfig = ConfigMount.mount( entityManager,
                                  "bugalert/config",
                                  "BugAlert::BugAlertConfig", "w" )
