#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCliModes
import BmpAgent
import CliCommand
import CliMatcher
from CliPlugin.BmpShowCli import runSocketCommand
from CliToken.Clear import clearKwNode
from CommonGuards import standbyGuard

#--------------------------------------------------------------------------------
# clear bgp monitoring internal
#--------------------------------------------------------------------------------
class ClearBgpMonitoringInternalCmd( CliCommand.CliCommandClass ):
   syntax = 'clear bgp monitoring internal'
   data = {
      'clear': clearKwNode,
      'bgp': CliMatcher.KeywordMatcher( 'bgp', helpdesc='Bgp' ),
      'monitoring': CliMatcher.KeywordMatcher( 'monitoring', 'BGP monitoring' ),
      'internal': CliCommand.Node(
         matcher=CliMatcher.KeywordMatcher(
            'internal', helpdesc='BMP Agent internal status' ),
         guard=standbyGuard ),
   }

   @staticmethod
   def handler( mode, args ):
      runSocketCommand( mode, BmpAgent.name, 'state', 'clear' )

BasicCliModes.EnableMode.addCommandClass( ClearBgpMonitoringInternalCmd )
