# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import AgentDirectory
import TechSupportCli

sysname = None

#------------------------------------------------------------------------------
# BMC commands in "show tech-support"
#------------------------------------------------------------------------------

def _showTechBmcCmds():
   if AgentDirectory.agentIsRunning( sysname, 'Bmc' ):
      return [
         'show system bmc status',
      ]
   else:
      return []

TechSupportCli.registerShowTechSupportCmdCallback( '2018-12-04 11:26:55',
                                                   _showTechBmcCmds )

#------------------------------------------------------------------------------
# Plugin
#------------------------------------------------------------------------------

def Plugin( entityManager ):
   global sysname
   sysname = entityManager.sysname()
