#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

# pylint: disable=ungrouped-imports

import BasicCliModes
import CliCommand
import CliMatcher
import CliPlugin.BlackBox as BlackBox
from CliToken.Hardware import hardwareMatcherForConfig

#--------------------------------------------------------------------------------
# [ no ] [ default ] hardware console persistent logging
#--------------------------------------------------------------------------------
class HardwareConsolePersistentLoggingCmd( CliCommand.CliCommandClass ):
   syntax = 'hardware console persistent logging'
   noOrDefaultSyntax = 'hardware console persistent logging ...'
   data = {
      'hardware': hardwareMatcherForConfig,
      'console': CliCommand.Node( matcher=CliMatcher.KeywordMatcher(
                                    'console', helpdesc='Serial console' ),
                                  guard=BlackBox.blackboxGuard ),
      'persistent': 'Persistent console',
      'logging': 'Persistent console logging',
   }
   handler = BlackBox.enableBlackbox
   defaultHandler = BlackBox.enableBlackbox
   noHandler = BlackBox.disableBlackbox

BasicCliModes.GlobalConfigMode.addCommandClass( HardwareConsolePersistentLoggingCmd )
