#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

from CliPlugin import TechSupportCli

def _showTechSummaryCmds():
   return [
            'show bgp flow-spec ipv4 summary vrf all',
            'show bgp flow-spec ipv6 summary vrf all',
   ]

# Register the summary commands both for the regular show-tech and the
# show-tech summary.
TechSupportCli.registerShowTechSupportCmdCallback( '2020-05-12 11:05:42',
      _showTechSummaryCmds, summaryCmdCallback=_showTechSummaryCmds )

def _showTechFlowspecCmds():
   return [
            'show bgp flow-spec ipv4 summary vrf all',
            'show bgp flow-spec ipv6 summary vrf all',
            'show bgp flow-spec ipv4 detail vrf all',
            'show bgp flow-spec ipv6 detail vrf all',
   ]

TechSupportCli.registerShowTechSupportCmdCallback( '2020-08-12 11:14:00',
      _showTechFlowspecCmds,
      extended='flow-spec' )
