# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
import CliParser
import CliMatcher
import ConfigMount
import LazyMount
import Tac
from CliPlugin.VrfCli import vrfExists, DEFAULT_VRF

perlinkMode = Tac.Type( "Bfd::PerlinkMode" )
sessionType = Tac.Type( "Bfd::SessionType" )
operSessionType = Tac.Type( "Bfd::OperSessionType" )
historyInfo = Tac.Value( "Bfd::HistoryInfo" )
operState = Tac.Type( "Bfd::OperState" )
authType = Tac.Type( 'Bfd::BfdAuthType' )
routedPortWarning = {}
existingSessionWarning = {}
perlinkOnWarning = {}
rfc7130SupportedWarning = {}
rfc7130BfdNeighborWarning = {}

matcherBfd = CliMatcher.KeywordMatcher( 'bfd',
   helpdesc='Configure BFD specific configurations' )
matcherAuthProfile = CliMatcher.DynamicNameMatcher( ( lambda mode:
   authSharedSecretConfig.profile ), 'Shared-secret profile name' )
matcherInterval = CliMatcher.KeywordMatcher( 'interval',
   helpdesc='Set transmit rate in milliseconds' )
matcherMinRxDeprecated = CliMatcher.KeywordMatcher( 'min_rx',
   helpdesc='Set expected minimum incoming rate in milliseconds' )
matcherMinRx = CliMatcher.KeywordMatcher( 'min-rx',
   helpdesc='Set expected minimum incoming rate in milliseconds' )
matcherMultiplier = CliMatcher.KeywordMatcher( 'multiplier',
   helpdesc='Sets the BFD multiplier' )
matcherSession = CliMatcher.KeywordMatcher( 'session',
   helpdesc='BFD session settings' )

allVrfConfig = None
testAppConfigDir = None
authSharedSecretConfig = None
routingConfig = None
routing6Config = None
staticAppConfigDir = None

def getVrfNames( mode ):
   # Get list of all vrfs from global config, and append an entry for the default.
   # The global list of vrfs does not contain the default vrf.  Otherwise,
   # tab-completion for 'default' in the Cli won't work.
   vrfNames = allVrfConfig.vrf.members()
   vrfNames.append( Tac.newInstance( 'L3::VrfName', 'temp-status' ).defaultVrf )
   return sorted( vrfNames )

def getBfdTestAppVrfAppConfig( testAppDir, vrf ):
   testAppVrfDir = testAppDir.newEntity( 'Tac::Dir', '%s' % vrf )
   testCfg = testAppVrfDir.newEntity( 'Bfd::AppConfig', 'test' )
   testCfg.appPid = 1
   return testCfg

def delPeer ( peer, testCfg ):
   if peer in testCfg.peerConfigVer:
      del testCfg.peerConfigVer[ peer ]

def addPeer ( peer, testCfg ):
   if peer not in testCfg.peerConfigVer:
      testCfg.newPeerConfigVer( peer, 1 )

def addOrRemoveBfdSession( mode, args ):
   no = CliCommand.isNoOrDefaultCmd( args )
   peerAddr = args.get( 'PEERADDR' )
   intf = args.get( 'INTF' )
   vrfName = args.get( 'VRF', DEFAULT_VRF )
   srcAddr = args.get( 'SRCADDR' )
   tunnelId = args.get( 'TUNNEL' )
   interval = args.get( 'INTERVAL' )
   mult = args.get( 'MULTIPLIER' )

   if not vrfExists( vrfName ):
      mode.addError( "VRF %s not configured." % vrfName )
      return

   testCfgDir = ConfigMount.force( testAppConfigDir )
   testCfg = getBfdTestAppVrfAppConfig( testCfgDir, vrfName )
   add = not no
   if testCfg is None:
      print 'Unable to mount test AppConfig!'
      return
   addr = Tac.Value( 'Arnet::IpGenAddr', '%s' % peerAddr )
   peer = Tac.Value( 'Bfd::Peer', addr, vrfName )
   if intf:
      intf = Tac.Value( 'Arnet::IntfId', intf.name )
      peer.intf = intf

   if srcAddr:
      srcAddr = Tac.Value( 'Arnet::IpGenAddr', '%s' % srcAddr )
      peer.srcIp = srcAddr
      peer.type = sessionType.multihop
   elif tunnelId:
      peer.type = sessionType.sbfdInitiator
      peer.tunnelId = tunnelId

   if add:
      addPeer( peer, testCfg )
      if interval and mult:
         cfg = Tac.Value( 'Bfd::InitiatorTimerConfig', interval, mult )
         testCfg.peerToInitiatorConfigMap[ peer ] = cfg
   else:
      delPeer( peer, testCfg )
      del testCfg.peerToInitiatorConfigMap[ peer ]

def getAuthModeFromArgs( args ):
   if 'simple' in args:
      return authType.authPassword
   elif 'md5' in args:
      if 'meticulous' in args:
         return authType.authMeticulousMd5
      else:
         return authType.authKeyedMd5
   elif 'sha1' in args:
      if 'meticulous' in args:
         return authType.authMeticulousSha1
      else:
         return authType.authKeyedSha1
   elif 'disabled' in args:
      return authType.authNone
   return None

class BfdIpIntfConfigModelet( CliParser.Modelet ):
   modeletParseTree = CliParser.ModeletParseTree()
   def __init__( self, intfConfigMode ):
      CliParser.Modelet.__init__( self )

   @staticmethod
   def shouldAddModeletRule( mode ):
      return mode.intf.routingSupported()


def Plugin( entityManager  ):
   global allVrfConfig
   global testAppConfigDir
   global authSharedSecretConfig
   global routingConfig
   global routing6Config
   global staticAppConfigDir

   testAppConfigDir = ConfigMount.mount( entityManager,
                                          'bfd/config/app/test',
                                          'Tac::Dir', 'wic' )
   allVrfConfig = LazyMount.mount( entityManager, 'ip/vrf/config',
                                   'Ip::AllVrfConfig', 'r' )
   authSharedSecretConfig = LazyMount.mount( entityManager,
                                   'mgmt/security/sh-sec-prof/config',
                                   'Mgmt::Security::SharedSecretProfile::Config',
                                   'r' )
   routingConfig = LazyMount.mount( entityManager, 'routing/config',
                                    'Routing::Config', 'r' )
   routing6Config = LazyMount.mount( entityManager, 'routing6/config',
                                     'Routing6::Config', 'r' )
   staticAppConfigDir = ConfigMount.mount( entityManager,
                                           'bfd/config/app/static',
                                           'Tac::Dir', 'wic' )
