#!/usr/bin/env python
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliModel import List
from CliModel import Enum
from CliModel import Model
import os
import EosVersion

blockingReasonsDict = { 
   "IPv4uRPF" : "IPv4 uRPF is in ErrorDisabled state",
   "IPv6uRPF" : "IPv6 uRPF is in ErrorDisabled state",
   "directFlowEnabled" : "Directflow is enabled",
   "vrrpEnabled" : "VRRP is enabled",
   "resilientECMPv4" : "Resilient ECMP prefix is configured for IPv4",
   "resilientECMPv6" : "Resilient ECMP prefix is configured for IPv6",
   "lacpRateFastLocalConfigured" : "lacp fast rate configured locally",
   "lacpRateFastRemoteConfigured" : "lacp fast rate configured remotely",
   "openFlowEnabled" : "Openflow is enabled", 
   "pbrConfigured" : "Pbr is configured",
   "stpMode" : "Spanning-tree mode is not supported",
   "edgePort" : "Spanning-tree portfast is not enabled for one or more ports",
   "mstInstances" : "Spanning-tree is enabled with more than one MST instance",
   "stpBpduguard" : "Spanning-tree BPDU guard is not enabled for one or more ports",
   "maintenanceModeConfigured" : "Maintenance Mode is configured",
   "lagModeInconsistent" : "Lag Modes differ between hardware and configuration",
   "mlagStateUnstable" : "Mlag state is neither primary nor secondary",
   "mlagNotEstablished" : "Mlag peer negotiation is not done yet",
   "vxlanConfigured" : "Vxlan is configured",
   "tunnelIntfConfigured": "Tunnel Interface is configured",
}

warningReasonsDict = { 
   "bgpNoGrace" : "BGP is configured without graceful restart",
   "ospfNoGrace" : "OSPF is configured without graceful restart",
   "isisNoGrace" : "IS-IS is configured without graceful restart",
   "ospf3NoGrace" : "OSPF3 is configured without graceful restart",
   "pimEnabled" : "PIM is enabled",
   "ripEnabled" : "RIP is enabled",
   "varpEnabled" : "VARP is enabled",
   "igmpSnoopingEnabled" : "IGMP Snooping is enabled",
   "stpErrDisabled" : "One or more ports is errDisabled due to BPDU guard",
   "runtimeErrdisabledIntfs" : 
   "Runtime errdisabled interface(s) found. Please note that they will be re-enabled"
   " after hitless reload. If same conditions persist, interface(s) will be"
   " errdisabled again after the reload.",
   "ptpEnabled" : "PTP is enabled. PTP slaves will lose connection to the"
   " grandmaster and lose time sync.",
   "pfcWatchdogEnabled" : "PFC Watchdog is enabled. The current PFC Watchdog state"
   " may be lost on hitless reload. Monitoring will restart after the reload.",
   "mlagVersionCompatibility" : 
   "If you are performing an upgrade, and the Notes for the new version of EOS "
   "indicate that MLAG is not backwards-compatible with the currently installed "
   "version (%s), the upgrade will result in packet loss." % EosVersion.VersionInfo(
      sysdbRoot=None ),
   "mlagPortsActivePartial" : "",
   "reloadDelayConfigured" : "Mlag is configured with non-zero mlag/non-mlag "
   "reload-delay. This may result in packet loss",
   "pimBidirEnabled" : "PIM bidirectional is enabled",
   "pimHoldTime" : "Pim interface has join/prune holdtime that is less than two "
   "times default holdtime. This may result in packet loss",
}

def _generateHelpStr( reasonsDict ):
   helpStr = ""
   for key, val in reasonsDict.iteritems():
      helpStr += '%s : %s' % ( key, val ) + os.linesep
   return helpStr

def modifyValueOfWarningReasonsDict( reason, reasonStr ):
   warningReasonsDict[ reason ] = reasonStr

class ReloadHitlessBlockingReason( Model ):
   reason = Enum( values=blockingReasonsDict.keys(),
                  help=_generateHelpStr( blockingReasonsDict ) )

   def render( self ):
      print blockingReasonsDict[ self.reason ]

class ReloadHitlessWarningReason( Model ):
   reason = Enum( values=warningReasonsDict.keys(),
                  help=_generateHelpStr( warningReasonsDict ) )

   def render( self ):
      print warningReasonsDict[ self.reason ]


def render( blockingList, warningList, reloadCmd ):
   if blockingList:
      print "'%s' cannot proceed due to the following:" % reloadCmd
      for n in blockingList:
         print " ",
         n.render()
   if warningList:
      print "Warnings in the current configuration detected:"
      for n in warningList:
         print " ",
         n.render()
   if not blockingList and not warningList:
      print "No warnings or unsupported configuration found." 



class ReloadHitlessDisruption( Model ):
   blockingList = List( valueType=ReloadHitlessBlockingReason,
                        help="List blocking configuration for 'reload hitless'" )
   warningList = List( valueType=ReloadHitlessWarningReason,
                       help="List of warnings for 'reload hitless'" )

   def render( self ):
      render( self.blockingList, self.warningList, 'reload hitless' ) 

class ReloadFastbootDisruption( Model ):
   blockingList = List( valueType=ReloadHitlessBlockingReason,
                        help="List blocking configuration for 'reload fast-boot'" )
   warningList = List( valueType=ReloadHitlessWarningReason,
                       help="List of warnings for 'reload fast-boot'" )

   def render( self ):
      render( self.blockingList, self.warningList, 'reload fast-boot' )
