#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from ArnetModel import IpGenericAddress, MacAddress
from CliModel import DeferredModel, Dict

class RemoteBindingVlan( DeferredModel ):
   ipAddresses = Dict( keyType=IpGenericAddress,
                       valueType=MacAddress,
                       help='Dictionary of remote bindings' )

class RemoteBindingModel( DeferredModel ):
   vlans = Dict( keyType=int,
                 valueType=RemoteBindingVlan,
                 help='Dictionary of VLANs with remote bindings' )
