# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import BasicCli
import CliParser
from CliMode.RouterL2Vpn import RoutingL2VpnMode
import ConfigMount
import CliCommand
import CliMatcher
from CliToken.Router import routerMatcherForConfig as tokenRouter

l2VpnConfig = None

prefixListNameMatcher = CliMatcher.PatternMatcher(
      pattern=r'([A-Za-z0-9_:{}\[\]=\+-])([A-Za-z0-9_:{}\.\[\]=\+-]*)',
      helpdesc='Prefix-list name', helpname='WORD' )

class RouterL2VpnConfigMode( RoutingL2VpnMode, BasicCli.ConfigModeBase ):
   name = 'l2-vpn configuration'
   modeParseTree = CliParser.ModeParseTree()

   def __init__( self, parent, session ):
      RoutingL2VpnMode.__init__( self, None )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

# --------------------------------------------------------------------------
# 'router l2-vpn' to enter config-rtr-l2-vpn mode
# --------------------------------------------------------------------------
class RouterL2VpnModeCmd( CliCommand.CliCommandClass ):
   syntax = 'router l2-vpn'
   noOrDefaultSyntax = syntax
   data = {
         'router' : tokenRouter,
         'l2-vpn' : 'l2-vpn configuration',
   }

   @staticmethod
   def handler( mode, args ):
      childMode = mode.childMode( RouterL2VpnConfigMode )
      mode.session_.gotoChildMode( childMode )

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      l2VpnConfig.arpProxyPrefixList = ''
      l2VpnConfig.ndProxyPrefixList = ''
      l2VpnConfig.arpSelectiveInstall = False
      l2VpnConfig.rsFloodingDisabled = False
      l2VpnConfig.dadFloodingDisabled = False
      l2VpnConfig.virtualRouterNaFloodingDisabled = False
      l2VpnConfig.virtualRouterGarpFloodingDisabled = False

BasicCli.GlobalConfigMode.addCommandClass( RouterL2VpnModeCmd )

# --------------------------------------------------------------------------
# arp proxy prefix-list WORD
# ( no | default ) arp proxy prefix-list
# [ no | default ] arp selective-install
# --------------------------------------------------------------------------
class RouterL2VpnArpConfigCmd( CliCommand.CliCommandClass ):
   syntax = 'arp ( ( proxy prefix-list WORD ) | ( selective-install ) )'
   noOrDefaultSyntax = 'arp ( ( proxy prefix-list ) | ( selective-install ) )'

   data = {
      'arp' : 'Arp configuration',
      'proxy' : 'Proxy ARP',
      'prefix-list' : 'Prefix list',
      'WORD' : prefixListNameMatcher,
      'selective-install' : 'Install ARP entries for remote hosts on demand'
   }

   @staticmethod
   def handler( mode, args ):
      proxy = args.get( 'proxy' )
      if proxy:
         prefixListName = args[ 'WORD' ]
         l2VpnConfig.arpProxyPrefixList = prefixListName
      selectiveInstall = args.get( 'selective-install' )
      if selectiveInstall:
         l2VpnConfig.arpSelectiveInstall = True

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      proxy = args.get( 'proxy' )
      if proxy:
         l2VpnConfig.arpProxyPrefixList = ''
      selectiveInstall = args.get( 'selective-install' )
      if selectiveInstall:
         l2VpnConfig.arpSelectiveInstall = False

RouterL2VpnConfigMode.addCommandClass( RouterL2VpnArpConfigCmd )

# --------------------------------------------------------------------------
# nd proxy prefix-list WORD
# ( no | default ) nd proxy prefix-list
# [ no | default ] nd ( rs flooding disabled | dad flooding disabled )
# --------------------------------------------------------------------------
class RouterL2VpnNdConfigCmd( CliCommand.CliCommandClass ):
   syntax = 'nd ( ( proxy prefix-list WORD ) |' \
                 '( rs flooding disabled ) |' \
                 '( dad flooding disabled ) )'
   noOrDefaultSyntax = 'nd ( ( proxy prefix-list ) |' \
                            '( rs flooding disabled ) |' \
                            '( dad flooding disabled ) )'

   data = {
      'nd' : 'Neighbor discovery configuration',
      'proxy' : 'Proxy ND',
      'prefix-list' : 'Prefix list',
      'rs' : 'Router solicitation',
      'flooding' : 'Vtep flooding',
      'disabled' : 'Disabled',
      'dad' : 'Duplicate address detection',
      'WORD' : prefixListNameMatcher,
   }

   @staticmethod
   def handler( mode, args ):
      proxy = args.get( 'proxy' )
      if proxy:
         prefixListName = args[ 'WORD' ]
         l2VpnConfig.ndProxyPrefixList = prefixListName
      rs = args.get( 'rs' )
      if rs:
         l2VpnConfig.rsFloodingDisabled = True
      dad = args.get( 'dad' )
      if dad:
         l2VpnConfig.dadFloodingDisabled = True

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      proxy = args.get( 'proxy' )
      if proxy:
         l2VpnConfig.ndProxyPrefixList = ''
      rs = args.get( 'rs' )
      if rs:
         l2VpnConfig.rsFloodingDisabled = False
      dad = args.get( 'dad' )
      if dad:
         l2VpnConfig.dadFloodingDisabled = False

RouterL2VpnConfigMode.addCommandClass( RouterL2VpnNdConfigCmd )

# --------------------------------------------------------------------------
# [ no | default ] virtual-router ( neighbor advertisement flooding disabled |
#                                   arp advertisement flooding disabled )
# --------------------------------------------------------------------------
class RouterL2VpnVirtualRouterConfigCmd( CliCommand.CliCommandClass ):
   syntax = 'virtual-router ( ( neighbor advertisement flooding disabled ) |' \
                             '( arp advertisement flooding disabled ) )'
   noOrDefaultSyntax = syntax

   data = {
      'virtual-router' : 'Virtual router configuration',
      'neighbor' : 'Neighbor',
      'advertisement' : 'Advertisement',
      'flooding' : 'Vtep flooding',
      'disabled' : 'Disabled',
      'arp' : 'Arp',
   }

   @staticmethod
   def handler( mode, args ):
      neighbor = args.get( 'neighbor' )
      if neighbor:
         l2VpnConfig.virtualRouterNaFloodingDisabled = True
      arp = args.get( 'arp' )
      if arp:
         l2VpnConfig.virtualRouterGarpFloodingDisabled = True

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      neighbor = args.get( 'neighbor' )
      if neighbor:
         l2VpnConfig.virtualRouterNaFloodingDisabled = False
      arp = args.get( 'arp' )
      if arp:
         l2VpnConfig.virtualRouterGarpFloodingDisabled = False

RouterL2VpnConfigMode.addCommandClass( RouterL2VpnVirtualRouterConfigCmd )

def Plugin( entityManager ):
   global l2VpnConfig

   l2VpnConfig = ConfigMount.mount( entityManager, "routing/l2vpn/config",
                                    "Routing::L2Vpn::Config", "w" )
