#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import sys
import BasicCli
import CliMatcher
import CliToken.Ipv6
from CliPlugin.IpEth import ShowArpExpr, neighborAfterShowKw
import ShowCommand
import SharedMem
import Smash
from ArpSuppressionModel import RemoteBindingModel
import Tac
import CliPrint

cprinter = CliPrint.CliPrint().lib
remoteBindingConfig = None

def showArpSuppressionRemoteBindings( mode, filterAf, filterVlanId ):
   assert filterAf
   if not filterVlanId:
      filterVlanId = 0

   fmt = CliPrint.TEXT
   if mode:
      outputFormat = cprinter.stringToOutputFormat( mode.session_.outputFormat_ )
      fmt = outputFormat.value
   fd = sys.stdout.fileno()

   helper = Tac.newInstance( "ArpSuppression::ArpSuppressionShowHelper",
         remoteBindingConfig )
   helper.showArpRemote( fd, fmt, filterAf, filterVlanId )

   return RemoteBindingModel

class ShowArpRemote( ShowCommand.ShowCliCommandClass ):
   syntax = "show arp | ( ipv6 neighbors ) remote [ vlan VLAN ]"
   data = {
      'arp' : ShowArpExpr,
      'ipv6' : CliToken.Ipv6.ipv6MatcherForShow,
      'neighbors' : neighborAfterShowKw,
      'remote' : "Remote host bindings",
      'vlan' : 'Show information for specific VLAN',
      'VLAN' : CliMatcher.IntegerMatcher( 1, 4094,
                                          helpdesc='Identifier for a Virtual LAN' )
      }
   cliModel = RemoteBindingModel

   @staticmethod
   def handler( mode, args ):
      if 'ipv6' in args:
         filterAf = 'ipv6'
      else:
         filterAf = 'ipv4'
      return showArpSuppressionRemoteBindings( mode, filterAf, args.get( 'VLAN' ) )

BasicCli.addShowCommandClass( ShowArpRemote )

def Plugin( entityManager ):
   smashEm = SharedMem.entityManager( sysdbEm=entityManager )
   readerInfo = Smash.mountInfo( 'reader' )

   global remoteBindingConfig
   remoteBindingConfig = smashEm.doMount( 'arpSuppression/remoteBindingConfig/evpn',
                                          'ArpSuppression::RemoteBindingConfig',
                                          readerInfo )
