# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

#-----------------------------------------------------
# Register Arp show commands into "show tech-support".
#-----------------------------------------------------
import TechSupportCli

def _showTechCmds1():
   cmds1 = [ 
             'show arp',
             'show ipv6 neighbor',
           ]
   return cmds1

# Timestamps are made up to maintain historical order within show tech-support
TechSupportCli.registerShowTechSupportCmdCallback( 
                                '2010-01-01 00:06:10',
                                _showTechCmds1 )

#--------------------------------------------------------------------------
# register show tech-support extended evpn
#--------------------------------------------------------------------------
def _showTechEvpnCmds():
   return [
            'show arp',
          ]

TechSupportCli.registerShowTechSupportCmdCallback( '2017-11-03 12:06:12',
                                                   _showTechEvpnCmds,
                                                   extended = 'evpn' )

