#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliModel import List, Model, Str, Dict, Enum
from IntfModel import Interface
from TableOutput import TableFormatter
from TableOutput import Headings
from ArnetModel import IpGenericAddress

class ArpInputEntry( Model ):
   ipAddr = IpGenericAddress( help='Ip or Ipv6 address' )
   intfId = Interface( help='Name of the interface' )
   ethAddr = Str( help='MAC address' )
   entryType = Enum( values=( 'static', 'dynamic' ), 
      help='Type of entry (Static/Dyn)' )
   refreshTime = Str( help='Quick Refresh time' )
   genId = Str( help='Gen ID of dynamic entries' )
   source = Str( help='Source of the ARP entries' )

class ArpInputEntryList( Model ):
   entrys = List( valueType=ArpInputEntry, help="ARP input entry list" )

class ArpInputEntriesModel( Model ):
   entryMap = Dict( keyType=str, valueType=ArpInputEntryList,
         help="Mapping of VRF name to list of ARP entries")

   def render( self ):
      for vrf, entryList in self.entryMap.items():
         print '\nVRF: %s' % ( vrf )
         t = TableFormatter()
         headings = ( ( "IP", "l" ),
                      ( "MAC", "l" ),
                      ( "Type", "l" ),
                      ( "Source", "l" ),
                      ( "Interface", "l" ),
                      ( "GenId", "l" ),
                      ( "RefreshTime(secs)", "l" ), )
         th = Headings( headings )
         th.doApplyHeaders( t )
         for i in entryList.entrys:
            t.newRow( i.ipAddr, i.ethAddr, i.entryType, i.source, 
                  i.intfId.stringValue, i.genId, i.refreshTime )
         print t.output()
