# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import Arnet
from ArnetModel import IpGenericAddress
from CliModel import (
      Dict,
      Int,
      List,
      Model
)
from IntfModels import Interface

class Capacity( Model ):
   capacity = Int( help='Capacity of the neighbor cache' )
   count = Int( help='Count of the neighbor cache entries' )
   cacheEntries = List( valueType=IpGenericAddress,
                        help='List of IP addresses of the neighbor cache entries' )

   def render( self ):
      print( '  Capacity: %d' % self.capacity )
      print( '  Entries: %d' % self.count )
      for cacheEntry in sorted( self.cacheEntries ):
         print( '    ' + str( cacheEntry ) )

class CapacityKinds( Model ):
   interfaces = Dict( keyType=Interface,
                      valueType=Capacity,
                      help='Mapping from interface to neighbor cache capacity' )

class ArpAgentCacheCapacities( Model ):
   capacityKinds = Dict( valueType=CapacityKinds,
         help='Mapping from cache entry kind to neighbor cache capacity kind' )

   def render( self ):
      for cacheKind in Arnet.sortIntf( self.capacityKinds.keys() ):
         print( "Cache Entry Kind: " + cacheKind )
         capacityKinds = self.capacityKinds[ cacheKind ]
         for interface in sorted( capacityKinds.interfaces.keys() ):
            capacity = capacityKinds.interfaces[ interface ]
            print( interface )
            capacity.render()

