# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import SharedMem
import Shark
from CliPlugin.ArpAgentCacheCapacityModels import (
      ArpAgentCacheCapacities,
      Capacity,
      CapacityKinds
)
import Tac

shmemEntityManager = None

class CacheCapacityCliMounter( object ):
   def __init__( self, shmemEm ):
      self.shmemEm = SharedMem.CliMountGroup( shmemEm=shmemEm )

   def cacheCapacityStatusDir( self ):
      return self.shmemEm.doMount( 'arp/cacheCapacity/status',
            'Arp::CacheCapacity::StatusDir', Shark.mountInfo( 'shadow' ) )

   def doClose( self ):
      self.shmemEm.doClose( blocking=True )

def capacityFromStatus( status, summary ):
   capacity = Capacity( capacity=status.capacity,
                        count = len( status.cacheEntry ) )
   if not summary:
      capacity.cacheEntries = status.cacheEntry.keys()

   return capacity

# Example output:
# Entry Kind: dynamic
# Ethernet1
#   Capacity: 5
#   Entries: 3
#     1::1
#     1::2
#     1::3
# Ethernet2
#   Capacity: 5
#   Entries: 3
#     2::2
#     2::5
#     2::8
def showArpAgentCacheCapacity( mode, args ):
   # mount the shmem
   shmemCliMounter = CacheCapacityCliMounter( shmemEntityManager )
   cacheCapacityStatusDir = shmemCliMounter.cacheCapacityStatusDir()
   shmemCliMounter.doClose()

   if 'ipv4' in args:
      intfStatus = cacheCapacityStatusDir.arpIntfStatus
   elif 'ipv6' in args:
      intfStatus = cacheCapacityStatusDir.nbrIntfStatus
   else:
      intfStatus = None

   allCacheKinds = set( ( 'dynamic', ) )
   cacheKinds = set()
   if 'dynamic' in args:
      cacheKinds.add( 'dynamic' )
   if not cacheKinds:
      cacheKinds = allCacheKinds

   intfId = None
   interface = args.get( 'INTF' )
   if interface:
      if not interface.lookup() or not interface.status().deviceName:
         mode.addError( "%s not operational" % interface.name )
         return None
      intfId = Tac.Value( 'Arnet::IntfId', interface.name )

   summary = args.get( 'summary' )

   model = ArpAgentCacheCapacities()

   for cacheKind in cacheKinds:
      capacityKinds = CapacityKinds()
      model.capacityKinds[ cacheKind ] = capacityKinds
      if not intfId:
         # give all the intfs that have a status
         for intfId, status in intfStatus.iteritems():
            capacity = capacityFromStatus( status, summary )
            capacityKinds.interfaces[ intfId ] = capacity
      else:
         if intfId in intfStatus:
            status = intfStatus[ intfId ]
            capacity = capacityFromStatus( status, summary )
            capacityKinds.interfaces[ intfId ] = capacity

   return model

def Plugin( entityManager ):
   global shmemEntityManager
   shmemEntityManager = SharedMem.entityManager( sysdbEm=entityManager )
