#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import Tac
from ArnetModel import IpGenericAddress
from CliModel import DeferredModel
from CliModel import Dict
from CliModel import Enum
from CliModel import List
from CliModel import Model
from CliPlugin.BgpCliModels import RouteTarget

##########
# Models for "show bgp rt-membership floodlist"
##########

class ShowRtMembershipFloodlistRouteTargetModel( DeferredModel ):
   peers = List( valueType=IpGenericAddress,
                 help='RT membership VRF and route target peer floodlist' )

class ShowRtMembershipFloodlistVrfModel( DeferredModel ):
   routeTargets = Dict(
      keyType=RouteTarget,
      valueType=ShowRtMembershipFloodlistRouteTargetModel,
      help='RT membership VRF floodlist information, keyed by route target' )

class ShowRtMembershipFloodlistModel( DeferredModel ):
   vrfs = Dict( valueType=ShowRtMembershipFloodlistVrfModel,
                help='RT membership floodlist information, keyed by VRF name' )

##########
# Models for "show bgp neighbors <nbr> rt-membership filter"
##########

class ShowRtMembershipNeighborFilterPeerModel( DeferredModel ):
   routeTargets = List( valueType=RouteTarget,
                        help='RT membership VRF and neighbor route target filter' )

class ShowRtMembershipNeighborFilterVrfModel( DeferredModel ):
   peers = Dict(
      keyType=IpGenericAddress,
      valueType=ShowRtMembershipNeighborFilterPeerModel,
      help='RT membership VRF neighbor filter information, keyed by peer address' )

class ShowRtMembershipNeighborFilterModel( DeferredModel ):
   vrfs = Dict( valueType=ShowRtMembershipNeighborFilterVrfModel,
                help='RT membership neighbor filter information, keyed by VRF name' )

##########
# Models for "show bgp rcf <func-name>"
##########

rcfFunctionStatusHelp = '''Routing control function state.
  active - Routing control function is valid
  missingReference - Routing control function is missing an external reference
  missingSymbol - Routing control function symbol is missing'''

# Used to map CLI render of RCF function status to JSON camelcase form
RCF_FUNCTION_STATUS_DICT = { 'active' : 'active',
                             'missing reference' : 'missingReference',
                             'missing symbol' : 'missingSymbol' }

class ShowBgpRcfFunctionModel( Model ):
   status = Enum( values=RCF_FUNCTION_STATUS_DICT.values(),
                  help=rcfFunctionStatusHelp )

class ShowBgpRcfModel( Model ):
   functions = Dict(
         keyType=str,
         valueType=ShowBgpRcfFunctionModel,
         help='Routing control function information, keyed by function name' )
