# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import Tracing
import RoutingBgpShowCli

traceHandle = Tracing.Handle( 'ArBgpCli' )
t1 = traceHandle.trace1

# a global that holds the extended community parsing state machinery
# the Evpn plugin accesses this state machine to set up additional parsing rules for
# Evpn extended communities.
# The extCommParser will be used by CliPlugins for rendering extended communities
# from their U64 representations.
bgpExtCommParserContainerSm = None

def getBgpExtCommParserContainerSm():
   global bgpExtCommParserContainerSm
   if bgpExtCommParserContainerSm is None:
      bgpExtCommParserContainerSm = Tac.newInstance(
            "Routing::Bgp::BgpParseExtCommContainerSm" )
      t1( 'getBgpExtCommParserContainerSm: created bgpExtCommParserContainerSm' )
   return bgpExtCommParserContainerSm

def getVrfList( vrfName=None ):
   vrfList = Tac.newInstance( 'BgpShowCli::VrfList' )

   # Populate the vrfList queue as VrfExecCmdDec would have done
   if vrfName == '':
      vrfList.vrf.enq( 'default' )
   elif vrfName == 'all':
      vrfList.vrf.enq( 'default' )
      for v in sorted( RoutingBgpShowCli.getVrfsFunc() ):
         if vrfName != 'default':
            vrfList.vrf.enq( v )
   else:
      vrfList.vrf.enq( vrfName )

   return vrfList

def doShowBgpDisabled( mode, vrfName ):
   mode.addWarning( 'BGP is disabled for VRF %s' % vrfName )
   return None
