# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from AclLib import HwAclMechanism
import BasicCli
import CliCommand
import CliExtensions
import CliParser
import CliToken
import ConfigMount
import LazyMount
import Tac

aclParamConfig = None
aclStatus = None

def haloToggleGuard( mode, token ):
   if aclStatus.haloToggleSupported:
      return None
   return CliParser.guardNotThisPlatform

#--------------------------------------------------------------------------------
# [ no | default ] hardware access-list mechanism
#                                            ( none | tcam | ( algomatch [ only ] ) )
#--------------------------------------------------------------------------------
aclMechanismAlgoMatchOnlyCanPromptForAbortHook = CliExtensions.CliHook()

def doConfirmAlgoMatchOnlyChange( mode ):
   if mode.session.commandConfirmation():
      for hook in aclMechanismAlgoMatchOnlyCanPromptForAbortHook.extensions():
         if hook( mode ):
            return False
   return True

class HardwareAclMechanismCmd( CliCommand.CliCommandClass ):
   syntax = 'hardware access-list mechanism ( none | tcam | ( algomatch [ only ] ) )'
   noOrDefaultSyntax = 'hardware access-list mechanism ...'
   data = {
      'hardware' : CliToken.Hardware.hardwareMatcherForConfig,
      'access-list' : 'Hardware parameter related to access-list',
      'mechanism' : CliCommand.guardedKeyword( 'mechanism',
         helpdesc='Hardware access-list mechanism', guard=haloToggleGuard ),
      'none' : 'None',
      'tcam' : 'Use Tcam',
      'algomatch' : 'Use AlgoMatch',
      'only' : 'Disable security ACLs on non-algomatch hardware',
   }

   @staticmethod
   def handler( mode, args ):
      no = CliCommand.isNoOrDefaultCmd( args )
      aclMechanism = args.get( 'none', args.get( 'tcam', args.get( 'algomatch' ) ) )
      aclMechanismAlgoMatchOnly = 'only' in args
      # we need to check if we are moving out of algoMatchOnly mode here
      if( ( aclMechanismAlgoMatchOnly is None ) and
          ( aclParamConfig.algoMatchOnly is True ) ):
         if not doConfirmAlgoMatchOnlyChange( mode ):
            return
         aclParamConfig.algoMatchOnly = False
      oldHwAclMechanism = aclParamConfig.hwAclMechanism
      if no is not False:
         aclParamConfig.hwAclMechanism = HwAclMechanism.hwAclMechanismUnknown
      elif aclMechanism == 'algomatch':
         if( ( aclMechanismAlgoMatchOnly is not None ) and
             ( aclParamConfig.algoMatchOnly is False ) ):
            if not doConfirmAlgoMatchOnlyChange( mode ):
               return
            aclParamConfig.algoMatchOnly = True
         aclParamConfig.hwAclMechanism = HwAclMechanism.hwAclMechanismAlgoMatch
      elif aclMechanism == 'tcam':
         aclParamConfig.hwAclMechanism = HwAclMechanism.hwAclMechanismTcam
      elif aclMechanism == 'none':
         aclParamConfig.hwAclMechanism = HwAclMechanism.hwAclMechanismNone

      if aclParamConfig.hwAclMechanism != oldHwAclMechanism:
         mode.addWarning( 'Change will take effect only after switch reboot.' )

   noOrDefaultHandler = handler

BasicCli.GlobalConfigMode.addCommandClass( HardwareAclMechanismCmd )

def Plugin( entityManager ):
   global aclParamConfig
   global aclStatus
   aclParamConfig = ConfigMount.mount( entityManager, 'acl/paramconfig',
                                       'Acl::ParamConfig', 'w' )

   # used for CLI guard
   aclStatus = LazyMount.mount( entityManager, 'acl/status/all', 'Acl::Status', 'r' )
