# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliCommand
from CliMode.MplsEvpnMode import MplsEvpnMode
import CliParser
import ConfigMount
import LazyMount

# Global Cli variables
evpnMplsConfig = None
bridgingHwCapabilities = None

def mplsEvpnSupportedGuard( mode, token ):
   if bridgingHwCapabilities.mplsEvpnSupported:
      return None
   return CliParser.guardNotThisPlatform

class MplsEvpnConfigMode( MplsEvpnMode, BasicCli.ConfigModeBase ):
   name = 'config-mpls-evpn'
   modeParseTree = CliParser.ModeParseTree()

   def __init__( self, parent, session ):
      self.session_ = session
      MplsEvpnMode.__init__( self )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

#--------------------------------------------------------------------------------
# mpls evpn
#--------------------------------------------------------------------------------
class MplsEvpnCmd( CliCommand.CliCommandClass ):
   syntax = 'mpls evpn'
   data = {
      'mpls' : CliCommand.guardedKeyword( 'mpls',
         helpdesc='Global MPLS configuration commands',
         guard=mplsEvpnSupportedGuard ),
      'evpn' : 'Global EVPN configuration commands',
   }

   @staticmethod
   def handler( mode, args ):
      childMode = mode.childMode( MplsEvpnConfigMode )
      mode.session_.gotoChildMode( childMode )

BasicCli.GlobalConfigMode.addCommandClass( MplsEvpnCmd )

#--------------------------------------------------------------------------------
# [ no | default ] label-stack control-word
#--------------------------------------------------------------------------------
class LabelStackControlWordCmd( CliCommand.CliCommandClass ):
   syntax = 'label-stack control-word'
   noOrDefaultSyntax = syntax
   data = {
      'label-stack' : 'Configure label stack',
      'control-word' : 'Enable control word',
   }

   @staticmethod
   def handler( mode, args ):
      evpnMplsConfig.controlWordEnabled = True

   @staticmethod
   def noHandler( mode, args ):
      evpnMplsConfig.controlWordEnabled = False

   defaultHandler = handler

MplsEvpnConfigMode.addCommandClass( LabelStackControlWordCmd )

#--------------------------------------------------------------------------------
# [ no | default ] label-stack entropy-label
#--------------------------------------------------------------------------------
class LabelStackEntropyLabelCmd( CliCommand.CliCommandClass ):
   syntax = 'label-stack entropy-label'
   noOrDefaultSyntax = syntax
   data = {
      'label-stack' : 'Configure label stack',
      'entropy-label' : 'Enable entropy label',
   }
   hidden = True

   @staticmethod
   def handler( mode, args ):
      evpnMplsConfig.entropyLabelEnabled = True

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      evpnMplsConfig.entropyLabelEnabled = False

MplsEvpnConfigMode.addCommandClass( LabelStackEntropyLabelCmd )

#--------------------------------------------------------------------------------
# [ no | default ] vlan service dot1q remove outer
#--------------------------------------------------------------------------------
class VlanServiceDot1QRemoveOuterCmd( CliCommand.CliCommandClass ):
   syntax = 'vlan service dot1q remove outer'
   noOrDefaultSyntax = syntax
   data = {
      'vlan' : 'Configure for EVPN vlans',
      'service' : 'Configure VLAN service mode',
      'dot1q' : 'Configure dot1q tag',
      'remove' : 'Remove dot1q tag',
      'outer' : 'Remove outer dot1q tag',
   }

   @staticmethod
   def handler( mode, args ):
      evpnMplsConfig.vlanServiceDot1qEnabled = False

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      evpnMplsConfig.vlanServiceDot1qEnabled = True

MplsEvpnConfigMode.addCommandClass( VlanServiceDot1QRemoveOuterCmd )

def Plugin( entityManager ):
   global evpnMplsConfig, bridgingHwCapabilities
   evpnMplsConfig = ConfigMount.mount( entityManager,
                                       'evpn/mplsConfig',
                                       'Evpn::MplsConfig', 'w' )
   bridgingHwCapabilities = LazyMount.mount( entityManager,
                                             'bridging/hwcapabilities',
                                             'Bridging::HwCapabilities', 'r' )
