#!/usr/bin/env python
# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import AleCliLib, IntfCli


#-------------------------------------------------------------------------------
# "clear counters" hook to clear platform-specific interface counters
#-------------------------------------------------------------------------------

def clearCountersHook( mode, intfs, sessionOnly, allIntfs ):
   request = AleCliLib.aleCliConfig.clearCountersRequest

   # We don't support per-session clear
   if sessionOnly:
      return

   if allIntfs:
      del request[ 'all' ]
      request[ 'all' ] = True
      return

   # Clear interface list
   for x in intfs:
      del request[ x.name ]
      request[ x.name ] = True

IntfCli.registerClearCountersHook( clearCountersHook )


