#!/usr/bin/env python
# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import SmashLazyMount
import Smash
import LazyMount
import Tracing
# pylint: disable-msg=W0601

__defaultTraceHandle__ = Tracing.Handle( 'StrataCliLib' )

aleCliConfig = None
entityManager = None
dropRouteStatus = None
resilientEcmpStatus = None
resilientEcmpStatus6 = None
routingHwConfig = None
routingHwStatus = None
routing6HwConfig = None
routing6HwStatus = None
routingHardwareRouteStatus = None
routing6HardwareRouteStatus = None
smashReaderInfo = None
vrfIdMap = None
vrfTableStatus = None

def Plugin( em ):
   global entityManager
   entityManager = em

   global aleCliConfig
   aleCliConfig = LazyMount.mount( em, 'hardware/ale/cliconfig',
                                   'Ale::HwCliConfig', 'w' )

   global routingHwConfig
   routingHwConfig = LazyMount.mount( em, "routing/hardware/config",
                                      "Routing::Hardware::Config", "w" )

   global routingHwStatus
   routingHwStatus = LazyMount.mount( em, "routing/hardware/status",
                                      "Routing::Hardware::Status", "r" )

   global routing6HardwareRouteStatus
   routing6HardwareRouteStatus = LazyMount.mount( em,
                                                  "routing6/hardware/route/status",
                                                  "Routing6::Hardware::RouteStatus",
                                                  'r' )
   global routing6HwConfig
   routing6HwConfig = LazyMount.mount( em, "routing6/hardware/config",
                                       "Routing6::Hardware::Config", "w" )
   global routing6HwStatus
   routing6HwStatus = LazyMount.mount( em, "routing6/hardware/status",
                                      "Routing6::Hardware::Status", "r" )

   global routingHardwareRouteStatus
   routingHardwareRouteStatus = LazyMount.mount( em,
                                                 "routing/hardware/route/status",
                                                 "Routing::Hardware::RouteStatus",
                                                 'r' )

   global vrfTableStatus
   vrfTableStatus = LazyMount.mount( em, 'ale/vrfTable/status',
                                     'Ale::VrfTableStatus', 'r' )

   global dropRouteStatus
   dropRouteStatus = SmashLazyMount.mount( em,
                                      'routing/dropRouteStatus',
                                      'Smash::RouteMonitor::DropRouteStatus',
                                      Smash.mountInfo( 'reader' ) )

   global vrfIdMap
   vrfIdMap = SmashLazyMount.mount( entityManager, 'vrf/vrfIdMapStatus',
                                    'Vrf::VrfIdMap::Status',
                                    Smash.mountInfo( 'reader' ) )

   global smashReaderInfo
   smashReaderInfo = Smash.mountInfo( 'reader' )

   global resilientEcmpStatus
   resilientEcmpStatus = SmashLazyMount.mount( em,
                                               'routing/resilientEcmpStatus',
                                               'Ale::ResilientEcmpStatus',
                                               smashReaderInfo )

   global resilientEcmpStatus6
   resilientEcmpStatus6 = SmashLazyMount.mount( em,
                                                'routing6/resilientEcmpStatus',
                                                'Ale::ResilientEcmpStatus6',
                                                 smashReaderInfo )
