# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

# Monkey patch Tac.Run to provide the correct environment/std(out|err) to subproceses

import os
import sys

import Tac
import TacUtils

origTacRun = None

def newTacRun( *args, **kwargs ):
   # Tac.run has only 1 mandatory args; args[3]=stdout; args[4]=stderr
   # if no stdout/err provided, pass one explicitely to make sure we
   # ultimately use the correct fd (instead of some c code using fd 1 as default).
   assert len( args ) == 1, ( 'Tac.run within ConfigAgent doesn\'t take '
                              'more than 1 args. Please use kwargs instead. '
                              'Contact cli-dev@ for more info' )
   kwargs.setdefault( 'env', os.environ )
   kwargs.setdefault( 'stdout', sys.stdout )
   kwargs.setdefault( 'stderr', sys.stderr )
   return origTacRun( *args, **kwargs )

def init():
   global origTacRun
   assert TacUtils.run == Tac.run
   origTacRun = TacUtils.run
   TacUtils.run = newTacRun
   Tac.run = newTacRun
