# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

# Monkey patch subprocess.Popen to provide the correct parameters

import os
import subprocess
import sys

origSubprocessPopen = None

def newSubprocessPopen( *args, **kwargs ):
   kwargs.setdefault( 'env', os.environ )
   kwargs.setdefault( 'stdout', sys.stdout )
   kwargs.setdefault( 'stderr', sys.stderr )
   kwargs.setdefault( 'close_fds', True )
   return origSubprocessPopen( *args, **kwargs )

def init():
   global origSubprocessPopen
   origSubprocessPopen = subprocess.Popen
   subprocess.Popen = newSubprocessPopen
