#!/usr/bin/env python
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import CliMode

class VrfConfigMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'vrf %s' % self.vrfName_

   def __init__( self, param ):
      # param should be a tuple ( vrfName, service, config )
      # service should be the name of the service
      # config should be the mgmt config mount
      ( self.vrfName_, service, self.config_ ) = param
      self.modeKey = 'mgmt-%s-vrf' % ( service, )
      self.longModeKey = 'mgmt-%s-vrf-%s' % ( service, self.vrfName_ )
      CliMode.ConfigMode.__init__( self, param, parentMode=CliMode.ConfigMode )
      self.config()

   def config( self ):
      return self.config_.vrfConfig.newMember( self.vrfName_ )

   def shutdown( self ):
      self.config().serverState = "disabled"

   def noShutdown( self ):
      self.config().serverState = "enabled"

   def defaultShutdown( self ):
      self.config().serverState = "globalDefault"
