#!/usr/bin/env python
# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class VCenterMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'vmtracer session %s' % self.param_

   def __init__( self, param ):
      self.modeKey = "vmtracer-session"
      self.longModeKey = "vmtracer-session-%s" % param
      CliMode.ConfigMode.__init__( self, param )

class VShieldMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'vxlan'

   def __init__( self, param ):
      self.modeKey = "vmtracer-session-vxlan"
      self.longModeKey = "vmtracer-session-%s-vxlan" % param
      CliMode.ConfigMode.__init__( self, param )

