# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
import Tac
from TypeFuture import TacLazyType

TunnelTableIdentifier = TacLazyType( "Tunnel::TunnelTable::TunnelTableIdentifier" )

class TunnelRibsBaseMode( CliMode.ConfigMode ):
   def __init__( self ):
      self.modeKey = "tunnel-ribs"
      self.longModeKey = self.modeKey
      CliMode.ConfigMode.__init__( self, None )

   def enterCmd( self ):
      return self.modeKey

class TunnelRibBaseMode( CliMode.ConfigMode ):
   def __init__( self, tunnelRibName ):
      self.modeKey = "tunnel-rib"
      self.longModeKey = "%s-%s" % ( self.modeKey, tunnelRibName )
      self.tunnelRibName = tunnelRibName
      CliMode.ConfigMode.__init__( self, tunnelRibName,
                                   parentMode=TunnelRibsBaseMode )

   def enterCmd( self ):
      return "%s %s" % ( self.modeKey, self.tunnelRibName )

_tunnelTables = { TunnelTableIdentifier.bgpLuTunnelTable: "bgp labeled-unicast",
                  TunnelTableIdentifier.srTunnelTable: "isis segment-routing",
                  TunnelTableIdentifier.ldpTunnelTable: "ldp",
                  TunnelTableIdentifier.rsvpLerTunnelTable: "rsvp-ler",
                  TunnelTableIdentifier.nexthopGroupTunnelTable: "nexthop-group",
                  TunnelTableIdentifier.staticTunnelTable: "static" }
_reverseTunnelTables = dict( [ ( v.split()[ -1 ], k )
                               for k, v in _tunnelTables.items() ] )

def tunnelTableIdFromCliToken( cliToken ):
   return _reverseTunnelTables[ cliToken ]

def tunnelTableIdToCliToken( tunnelTableId ):
   return _tunnelTables[ tunnelTableId ]
