# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class SshUserMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return "username %s" % self.userName

   def __init__( self, param ):
      self.userName = param
      self.modeKey = "mgmt-ssh-user"
      self.longModeKey = "mgmt-ssh-user-%s" % self.userName
      CliMode.ConfigMode.__init__( self, self.longModeKey,
                                   parentMode=CliMode.ConfigMode )
