# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from CliMode.Te import GlobalTeMode


#Defines SRTE policy configuration modes:
#   segment-routing
#      policy endpoint <endpoint> color <color>
#         path-group preference <preference>
#
class SrTeModeBase( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'segment-routing'

   def __init__( self, param ):
      self.modeKey = "sr"
      self.longModeKey = "te-sr"
      CliMode.ConfigMode.__init__( self, param, parentMode=GlobalTeMode )

   def commentKey( self ):
      return self.longModeKey

class SrTePolicyModeBase( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'policy endpoint %s color %s' % ( self.endPoint, self.color )

   def __init__( self, param ):
      self.endPoint, self.color = param
      self.modeKey = "policy"
      self.longModeKey = "te-sr-policy"
      CliMode.ConfigMode.__init__( self, param, parentMode=SrTeModeBase )

   def commentKey( self ):
      return "te-sr-policy-%s-%s" % ( self.endPoint, self.color )

class SrTePolicyPathGroupModeBase( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'path-group preference %s' % ( self.preference )

   def __init__( self, param ):
      self.endPoint, self.color, self.preference = param
      self.modeKey = "path"
      self.longModeKey = "te-sr-policy-path"
      CliMode.ConfigMode.__init__( self, param, parentMode=SrTePolicyModeBase )

   def commentKey( self ):
      return "te-sr-policy-%s-%s-path-%s" % ( self.endPoint, self.color,
                                              self.preference )
