# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
'''
This module provides sub modes under traffic-engineering segment-routing mode related
to color mappings.

router traffic-engineering
   segment-routing
      color-dscp-mappings
'''

import CliMode
from CliMode.SrTePolicy import SrTeModeBase

class SrTeColorDscpModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      return "color-dscp-mappings"

   def __init__( self, param ):
      self.modeKey = "color-dscp"
      self.longModeKey = "te-sr-color-dscp"
      CliMode.ConfigMode.__init__( self, param, parentMode=SrTeModeBase )
