#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import CliParser
import CliMode
from CliMode.Classification import ( ClassificationConfigModeBase )
from CliMode.TrafficPolicy import ( MatchRuleBaseConfigMode, ActionsConfigModeBase )

class SamplePolicyModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      return "sample policy %s" % self.trafficPolicyName

   def __init__( self, param ):
      self.feature, self.parentMode, self.trafficPolicyName = param
      self.modeKey = "sample-policy"
      self.longModeKey = "%s-%s" % ( self.feature, self.trafficPolicyName )
      CliMode.ConfigMode.__init__( self, param,
                                   parentMode=self.parentMode )
      self.trafficPolicyContext = None

   def getContext( self ):
      return self.trafficPolicyContext

   def setContext( self, value ):
      self.trafficPolicyContext = value

class SamplePolicyConfigModeBase( SamplePolicyModeBase,
                                  ClassificationConfigModeBase ):

   def __init__( self, parent, session, context, feature ):
      SamplePolicyModeBase.__init__( self, ( feature, type( parent ),
                                             context.pmapName() ) )
      ClassificationConfigModeBase.__init__( self, parent, session )
      self.trafficPolicyContext = context
      self.trafficPolicy = context.currentPolicy()
      context.modeIs( self )

# Configuration mode for sample-policy
class SamplePolicyConfigMode( SamplePolicyConfigModeBase,
                              ClassificationConfigModeBase ):
   name = "sample-policy configuration"
   modeParseTree = CliParser.ModeParseTree()

# Match rule configuration mode
class SamplePolicyMatchRuleConfigMode( MatchRuleBaseConfigMode ):
   name = 'sample-policy match rule configuration'
   modeParseTree = CliParser.ModeParseTree()

# Action configuration mode
class SamplePolicyActionRuleConfigMode( ActionsConfigModeBase ):
   name = 'sample-policy action rule configuration'
   modeParseTree = CliParser.ModeParseTree()
