#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import CliMode

class RpkiCacheMode( CliMode.ConfigMode ):
   def __init__( self, param ):
      self.modeKey = 'rpki-cache'
      self.longModeKey = 'rpki-cache'
      CliMode.ConfigMode.__init__( self, param,
                                   parentMode=CliMode.BgpCommon.RoutingBgpBaseMode )

   def enterCmd( self ):
      return 'rpki cache %s' % self.param_

   def commentKey( self ):
      return 'rpki-cache-%s' % self.param_

class RpkiTransportTcpMode( CliMode.ConfigMode ):
   def __init__( self ):
      self.modeKey = 'rpki-cache-trans-tcp'
      self.longModeKey = 'rpki-cache-trans-tcp'
      CliMode.ConfigMode.__init__( self, None,
                                   parentMode=RpkiCacheMode )

   def enterCmd( self ):
      return 'transport tcp'

class RpkiOriginValidationBaseMode( CliMode.ConfigMode ):
   def __init__( self ):
      self.modeKey = 'rpki-origin-validation'
      self.longModeKey = 'rpki-origin-validation'
      CliMode.ConfigMode.__init__( self, None,
                                   parentMode=CliMode.BgpCommon.RoutingBgpBaseMode )

   def enterCmd( self ):
      return 'rpki origin-validation'

class RpkiTransportTlsMode( CliMode.ConfigMode ):
   def __init__( self ):
      self.modeKey = 'rpki-cache-trans-tls'
      self.longModeKey = 'rpki-cache-trans-tls'
      CliMode.ConfigMode.__init__( self, None,
                                   parentMode=RpkiCacheMode )

   def enterCmd( self ):
      return 'transport tls'
