#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class RouterGeneralBaseMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'router general'

   def __init__( self, param ):
      self.modeKey = 'router'
      self.longModeKey = 'router-general'
      CliMode.ConfigMode.__init__( self, param=param )

   def commentKey( self ):
      return self.longModeKey

class RouterGeneralVrfBaseMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'vrf %s' % self.vrfName

   def __init__( self, param ):
      self.vrfName = param
      self.modeKey = 'router'
      self.longModeKey = 'router-general-vrf-%s' % param
      CliMode.ConfigMode.__init__( self, param, parentMode=RouterGeneralBaseMode )
