#!/usr/bin/env python
# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from IpLibConsts import DEFAULT_VRF

class RipMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      if self.vrfName != DEFAULT_VRF:
         return 'router rip vrf %s' % \
             ( self.vrfName )
      return 'router rip'

   def __init__( self, param ):
      self.vrfName = param
      # The industry standard cli has "config-router" as the prompt
      # for this mode.
      self.modeKey = "router"
      if self.vrfName == DEFAULT_VRF:
         self.longModeKey = "router-rip"
      else:
         self.longModeKey = "router-rip-vrf-%s" % self.vrfName

      CliMode.ConfigMode.__init__( self, param )
