#!/usr/bin/env python
# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from CliMode.ContainerMgrMode import ContainerMgrMode

class RegistryMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'registry %s' % self.param_

   def __init__( self, param ):
      self.modeKey = 'container-mgr-registry'
      self.longModeKey = 'container-mgr-registry-%s' % param
      CliMode.ConfigMode.__init__( self, param, parentMode=ContainerMgrMode )

   def commentKey( self ):
      return self.longModeKey
