# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class ReflectorModeBase( CliMode.ConfigMode ):
   autoConfigSessionAllowed = False

   def enterCmd( self ):
      return "monitor ethernet reflectors"

   def __init__( self ):
      self.modeKey = "reflectors"
      self.longModeKey = "reflectors"
      CliMode.ConfigMode.__init__( self, self.longModeKey,
                                   parentMode=CliMode.ConfigMode )

class ReflectorInterfaceModeBase( CliMode.ConfigMode ):
   autoConfigSessionAllowed = False

   def enterCmd( self ):
      return 'reflector interface %s' % self.key

   def __init__( self, param ):
      self.key = param
      self.modeKey = 'reflector'
      self.longModeKey = 'reflector-%s' % self.key
      CliMode.ConfigMode.__init__( self, self.longModeKey,
                                   parentMode=ReflectorModeBase )
